/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.SmsVoiceUploaderResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

public class SmsVoiceUploader {
    String appkey;
    int appid;
    String url = "https://test.tim.qq.com/v3/tlsvoicesvr/upload_voice";
    SmsSenderUtil util = new SmsSenderUtil();

    public SmsVoiceUploader(int appid, String appkey) {
        this.appid = appid;
        this.appkey = appkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmsVoiceUploaderResult upload(String filePath) throws Exception {
        SmsVoiceUploaderResult result;
        String wholeUrl = String.format("%s?sdkappid=%d", this.url, this.appid);
        String random = "" + this.util.getRandom();
        String curTime = "" + System.currentTimeMillis() / 1000L;
        File voiceFile = new File(filePath);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(wholeUrl);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        ContentType contentType = ContentType.create((String)("application/octet-stream;\r\nContent-Length: " + voiceFile.length()));
        builder.addBinaryBody("file", voiceFile, contentType, voiceFile.getName());
        builder.addTextBody("sig", this.util.strToHash(String.format("appkey=%s&rand=%s&time=%s", this.appkey, random, curTime)));
        builder.addTextBody("rand", random);
        builder.addTextBody("time", curTime);
        HttpEntity multipart = builder.build();
        httpPost.setEntity(multipart);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)bos);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int httpRspCode = response.getStatusLine().getStatusCode();
            if (200 == httpRspCode) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                JSONObject json = new JSONObject(sb.toString());
                result = this.util.jsonToSmsVoiceUploaderResult(json);
                System.out.println(sb.toString());
            } else {
                result = new SmsVoiceUploaderResult();
                result.result = -1;
                result.msg = "http error " + httpRspCode;
            }
        }
        finally {
            httpClient.close();
        }
        return result;
    }
}

