/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.impl.wsdl.WsdlProjectPro;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ktc.soapui.maven.extension.AbstractSoapuiMojo;
import org.ktc.soapui.maven.extension.impl.ProjectConversionType;
import org.ktc.soapui.maven.extension.impl.enums.EnumConverter;

public class ConvertProjectMojo
extends AbstractSoapuiMojo {
    private File inputProject;
    private File outputProject;
    private String conversionType;

    @Override
    public void performExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Converting project " + this.conversionType));
        this.getLog().info((CharSequence)("from " + this.inputProject));
        this.getLog().info((CharSequence)("to " + this.outputProject));
        ProjectConversionType conversionTypeEnum = EnumConverter.toProjectConversionType(this.conversionType);
        this.outputProject.getParentFile().mkdirs();
        try {
            WsdlProjectPro wsdlProject = new WsdlProjectPro(this.inputProject.getAbsolutePath());
            wsdlProject.setComposite(conversionTypeEnum.isTargetedProjectComposite());
            wsdlProject.saveAs(this.outputProject.getAbsolutePath());
        }
        catch (Exception e) {
            throw new MojoFailureException("SoapUI has errors: " + e.getMessage(), (Throwable)e);
        }
    }
}

