/*
 * Decompiled with CFR 0.152.
 */
package com.rinoto.migramongo.spring.lookup;

import com.rinoto.migramongo.InitialMongoMigrationScript;
import com.rinoto.migramongo.MongoMigrationScript;
import com.rinoto.migramongo.lookup.ScriptLookupService;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;

public class SpringScriptLookupService
implements ScriptLookupService {
    private final ApplicationContext appContext;

    public SpringScriptLookupService(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public InitialMongoMigrationScript findInitialScript() {
        Collection values = this.appContext.getBeansOfType(InitialMongoMigrationScript.class).values();
        if (values.size() > 1) {
            throw new IllegalStateException("There cannot be more than one InitialMigrationScript!. Found " + values.size() + ": " + values);
        }
        return (InitialMongoMigrationScript)values.iterator().next();
    }

    public Collection<MongoMigrationScript> findMongoScripts() {
        Collection migScripts = this.appContext.getBeansOfType(MongoMigrationScript.class).values().stream().filter(ms -> !InitialMongoMigrationScript.class.isInstance(ms)).collect(Collectors.toList());
        return migScripts;
    }
}

