/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems;

import java.net.URI;
import java.net.URISyntaxException;

public final class URISupport {
    private URISupport() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    public static URI create(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        try {
            return new URI(scheme, userInfo, host, port, path, query, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URI create(String scheme, String authority, String path, String query, String fragment) {
        try {
            return new URI(scheme, authority, path, query, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URI create(String scheme, String host, String path, String fragment) {
        try {
            return new URI(scheme, host, path, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URI create(String scheme, String ssp, String fragment) {
        try {
            return new URI(scheme, ssp, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

