/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.exception.StringifiesStackTraces;
import com.github.searls.jasmine.io.ScansDirectory;
import com.github.searls.jasmine.model.ScriptSearch;
import com.github.searls.jasmine.runner.SpecRunnerTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractJasmineMojo
extends AbstractMojo
implements JasmineConfiguration {
    private static final String ERROR_FILE_DNE = "Invalid value for parameter '%s'. File does not exist: %s";
    @Parameter(property="jsSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript")
    private File jsSrcDir;
    @Parameter(property="jsTestSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript")
    private File jsTestSrcDir;
    @Parameter(defaultValue="org.openqa.selenium.htmlunit.HtmlUnitDriver")
    protected String webDriverClassName;
    @Parameter(defaultValue="FIREFOX_3_6")
    protected String browserVersion;
    @Parameter(defaultValue="documentation")
    protected String format;
    @Parameter
    protected List<String> preloadSources;
    @Parameter
    protected File customRunnerTemplate;
    @Parameter
    protected File customRunnerConfiguration;
    @Parameter(defaultValue="${project.build.directory}${file.separator}jasmine")
    protected File jasmineTargetDir;
    @Parameter(property="skipTests")
    protected boolean skipTests;
    @Parameter(property="haltOnFailure", defaultValue="true")
    protected boolean haltOnFailure;
    @Parameter(defaultValue="300")
    protected int timeout;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="SpecRunner.html")
    protected String specRunnerHtmlFileName;
    @Parameter(defaultValue="ManualSpecRunner.html")
    protected String manualSpecRunnerHtmlFileName;
    @Parameter(defaultValue="TEST-jasmine.xml")
    protected String junitXmlReportFileName;
    @Parameter(defaultValue="spec")
    protected String specDirectoryName;
    @Parameter(defaultValue="src")
    protected String srcDirectoryName;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="keepServerAlive", defaultValue="false")
    protected boolean keepServerAlive;
    @Parameter
    private final List<String> sourceIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> sourceExcludes = Collections.emptyList();
    @Parameter
    private final List<String> specIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> specExcludes = Collections.emptyList();
    @Parameter(property="jasmine.serverPort", defaultValue="8234")
    protected int serverPort;
    @Parameter(property="jasmine.specRunnerTemplate", defaultValue="DEFAULT")
    protected SpecRunnerTemplate specRunnerTemplate;
    @Deprecated
    @Parameter
    protected String scriptLoaderPath;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    protected ScriptSearch sources;
    protected ScriptSearch specs;
    protected StringifiesStackTraces stringifiesStackTraces = new StringifiesStackTraces();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.validateParameters();
        this.sources = new ScriptSearch(this.jsSrcDir, this.sourceIncludes, this.sourceExcludes);
        this.specs = new ScriptSearch(this.jsTestSrcDir, this.specIncludes, this.specExcludes);
        try {
            this.run();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The jasmine-maven-plugin encountered an exception: \n" + this.stringifiesStackTraces.stringify(e), e);
        }
    }

    public abstract void run() throws Exception;

    @Override
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Override
    public File getCustomRunnerTemplate() {
        return this.customRunnerTemplate;
    }

    @Override
    public SpecRunnerTemplate getSpecRunnerTemplate() {
        return this.specRunnerTemplate;
    }

    @Override
    public File getJasmineTargetDir() {
        return this.jasmineTargetDir;
    }

    @Override
    public String getSrcDirectoryName() {
        return this.srcDirectoryName;
    }

    @Override
    public ScriptSearch getSources() {
        return this.sources;
    }

    @Override
    public ScriptSearch getSpecs() {
        return this.specs;
    }

    @Override
    public String getSpecDirectoryName() {
        return this.specDirectoryName;
    }

    @Override
    public List<String> getPreloadSources() {
        this.addRequireJsIfNecessary();
        return this.preloadSources;
    }

    private void addRequireJsIfNecessary() {
        File requireJsFile;
        String scriptLoaderPath = this.getScriptLoaderPath() == null ? "require.js" : this.getScriptLoaderPath();
        String requireJsPath = String.format("%s/%s", this.jsSrcDir, scriptLoaderPath);
        if (SpecRunnerTemplate.REQUIRE_JS.equals((Object)this.specRunnerTemplate) && (requireJsFile = new File(requireJsPath)).exists()) {
            if (this.preloadSources == null) {
                this.preloadSources = new ArrayList<String>();
            }
            this.preloadSources.add(requireJsPath);
        }
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @Override
    public File getCustomRunnerConfiguration() {
        return this.customRunnerConfiguration;
    }

    @Override
    @Deprecated
    public String getScriptLoaderPath() {
        return this.scriptLoaderPath;
    }

    @Override
    public File getBasedir() {
        return this.mavenProject.getBasedir();
    }

    private void validateParameters() throws MojoExecutionException {
        this.fileExists("customRunnerConfiguration", this.customRunnerConfiguration);
        this.fileExists("customRunnerTemplate", this.customRunnerTemplate);
    }

    private void fileExists(String parameter, File file) throws MojoExecutionException {
        if (!(file == null || file.exists() && file.canRead())) {
            throw new MojoExecutionException(String.format(ERROR_FILE_DNE, parameter, file));
        }
    }
}

