/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.scim;

import com.github.seratch.jslack.SlackConfig;
import com.github.seratch.jslack.api.scim.SCIMApiErrorResponse;
import com.github.seratch.jslack.common.json.GsonFactory;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCIMApiException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(SCIMApiException.class);
    private final Response response;
    private final String responseBody;
    private final SCIMApiErrorResponse error;

    public SCIMApiException(Response response, String responseBody) {
        this(SlackConfig.DEFAULT, response, responseBody);
    }

    public SCIMApiException(SlackConfig config, Response response, String responseBody) {
        SCIMApiErrorResponse parsedErrorResponse;
        block2: {
            this.response = response;
            this.responseBody = responseBody;
            parsedErrorResponse = null;
            try {
                parsedErrorResponse = (SCIMApiErrorResponse)GsonFactory.createCamelCase(config).fromJson(responseBody, SCIMApiErrorResponse.class);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                String responseToPrint = responseBody.length() > 1000 ? responseBody.subSequence(0, 1000) + " ..." : responseBody;
                log.debug("Failed to parse the error response body: {}", (Object)responseToPrint);
            }
        }
        this.error = parsedErrorResponse;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public SCIMApiErrorResponse getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCIMApiException)) {
            return false;
        }
        SCIMApiException other = (SCIMApiException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        SCIMApiErrorResponse this$error = this.getError();
        SCIMApiErrorResponse other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SCIMApiException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        SCIMApiErrorResponse $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SCIMApiException(response=" + this.getResponse() + ", responseBody=" + this.getResponseBody() + ", error=" + this.getError() + ")";
    }
}

