/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.common.json;

import com.github.seratch.jslack.api.model.block.ContextBlockElement;
import com.github.seratch.jslack.api.model.block.composition.MarkdownTextObject;
import com.github.seratch.jslack.api.model.block.composition.PlainTextObject;
import com.github.seratch.jslack.api.model.block.element.ImageElement;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonContextBlockElementFactory
implements JsonDeserializer<ContextBlockElement>,
JsonSerializer<ContextBlockElement> {
    public ContextBlockElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String className = prim.getAsString();
        Class<? extends ContextBlockElement> clazz = this.getContextBlockElementClassInstance(className);
        return (ContextBlockElement)context.deserialize((JsonElement)jsonObject, clazz);
    }

    public JsonElement serialize(ContextBlockElement src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    private Class<? extends ContextBlockElement> getContextBlockElementClassInstance(String className) {
        switch (className) {
            case "image": {
                return ImageElement.class;
            }
            case "plain_text": {
                return PlainTextObject.class;
            }
            case "mrkdwn": {
                return MarkdownTextObject.class;
            }
        }
        throw new JsonParseException("Unknown context block element type: " + className);
    }
}

