/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.common.json;

import com.github.seratch.jslack.api.model.block.element.RichTextElement;
import com.github.seratch.jslack.api.model.block.element.RichTextSectionElement;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonRichTextElementFactory
implements JsonDeserializer<RichTextElement>,
JsonSerializer<RichTextElement> {
    public RichTextElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String className = prim.getAsString();
        Class<? extends RichTextElement> clazz = GsonRichTextElementFactory.detectElementClass(className);
        return (RichTextElement)context.deserialize((JsonElement)jsonObject, clazz);
    }

    public JsonElement serialize(RichTextElement src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    public static Class<? extends RichTextElement> detectElementClass(String className) {
        switch (className) {
            case "rich_text_section": {
                return RichTextSectionElement.class;
            }
            case "text": {
                return RichTextSectionElement.Text.class;
            }
            case "channel": {
                return RichTextSectionElement.Channel.class;
            }
            case "user": {
                return RichTextSectionElement.User.class;
            }
            case "emoji": {
                return RichTextSectionElement.Emoji.class;
            }
            case "link": {
                return RichTextSectionElement.Link.class;
            }
            case "team": {
                return RichTextSectionElement.Team.class;
            }
            case "usergroup": {
                return RichTextSectionElement.UserGroup.class;
            }
            case "date": {
                return RichTextSectionElement.Date.class;
            }
            case "broadcast": {
                return RichTextSectionElement.Broadcast.class;
            }
        }
        throw new JsonParseException("Unknown RichTextSectionElement type: " + className);
    }
}

