package com.github.seratch.jslack.app_backend.views.response;

import com.github.seratch.jslack.api.model.view.View;
import com.github.seratch.jslack.common.json.GsonFactory;
import lombok.*;

import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class ViewSubmissionResponse {

    private String responseAction; // push, update, errors, (no value to close)
    private View view;
    private Map<String, String> errors;

    // To override the builder generated by Lombok
    public static class ViewSubmissionResponseBuilder {
        private View view;

        public ViewSubmissionResponseBuilder viewAsString(String viewAsString) {
            View view = GsonFactory.createSnakeCase().fromJson(viewAsString, View.class);
            this.view = view;
            return this;
        }
    }
}
