/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.app_backend.oauth;

import com.github.seratch.jslack.Slack;
import com.github.seratch.jslack.api.methods.SlackApiException;
import com.github.seratch.jslack.api.methods.request.oauth.OAuthAccessRequest;
import com.github.seratch.jslack.api.methods.request.oauth.OAuthV2AccessRequest;
import com.github.seratch.jslack.api.methods.response.oauth.OAuthAccessResponse;
import com.github.seratch.jslack.api.methods.response.oauth.OAuthV2AccessResponse;
import com.github.seratch.jslack.app_backend.config.SlackAppConfig;
import com.github.seratch.jslack.app_backend.oauth.payload.VerificationCodePayload;
import java.io.IOException;

public class OAuthFlowOperator {
    private final Slack slack;
    private final SlackAppConfig config;

    public OAuthFlowOperator(Slack slack, SlackAppConfig config) {
        this.slack = slack;
        this.config = config;
    }

    public OAuthAccessResponse callOAuthAccessMethod(VerificationCodePayload payload) throws IOException, SlackApiException {
        return this.slack.methods().oauthAccess(OAuthAccessRequest.builder().clientId(this.config.getClientId()).clientSecret(this.config.getClientSecret()).code(payload.getCode()).redirectUri(this.config.getRedirectUri()).build());
    }

    public OAuthV2AccessResponse callOAuthV2AccessMethod(VerificationCodePayload payload) throws IOException, SlackApiException {
        return this.slack.methods().oauthV2Access(OAuthV2AccessRequest.builder().clientId(this.config.getClientId()).clientSecret(this.config.getClientSecret()).code(payload.getCode()).redirectUri(this.config.getRedirectUri()).build());
    }
}

