/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.app_backend.util;

import com.github.seratch.jslack.common.json.GsonFactory;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPayloadExtractor {
    private static final Logger log = LoggerFactory.getLogger(JsonPayloadExtractor.class);
    private static final List<String> EVENTS_API_TYPES = Arrays.asList("url_verification", "event_callback");

    public String extractIfExists(String requestBody) {
        if (requestBody == null) {
            return null;
        }
        char firstChar = requestBody.trim().charAt(0);
        if (firstChar == '{' || firstChar == '[') {
            try {
                String type;
                JsonObject payload;
                JsonElement json = (JsonElement)GsonFactory.createSnakeCase().fromJson(requestBody, JsonElement.class);
                if (json != null && (payload = json.getAsJsonObject()) != null && payload.get("type") != null && (type = payload.get("type").getAsString()) != null && EVENTS_API_TYPES.contains(type)) {
                    return requestBody;
                }
            }
            catch (JsonSyntaxException json) {}
        } else {
            String[] pairs;
            for (String pair : pairs = requestBody.split("\\&")) {
                String[] fields = pair.split("=");
                if (fields.length != 2) continue;
                try {
                    String name = URLDecoder.decode(fields[0].trim().replaceAll("\\n+", ""), "UTF-8");
                    if (!name.equals("payload")) continue;
                    String value = URLDecoder.decode(fields[1], "UTF-8");
                    return value;
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Failed to decode URL-encoded string values - {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return null;
    }
}

