/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.app_backend.events.servlet;

import com.github.seratch.jslack.app_backend.SlackSignature;
import com.github.seratch.jslack.app_backend.events.EventsDispatcher;
import com.github.seratch.jslack.app_backend.events.EventsDispatcherFactory;
import com.github.seratch.jslack.app_backend.events.servlet.SlackSignatureVerifier;
import com.github.seratch.jslack.common.json.GsonFactory;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SlackEventsApiServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SlackEventsApiServlet.class);
    private EventsDispatcher dispatcher = EventsDispatcherFactory.getInstance();
    private SlackSignatureVerifier signatureVerifier;

    protected abstract void setupDispatcher(EventsDispatcher var1);

    public void init() throws ServletException {
        super.init();
        this.setupDispatcher(this.dispatcher);
        this.dispatcher.start();
        this.signatureVerifier = new SlackSignatureVerifier(new SlackSignature.Generator(this.getSlackSigningSecret()));
    }

    public void destroy() {
        super.destroy();
        this.dispatcher.stop();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean validSignature;
        String requestBody = this.doReadRequestBodyAsString(req);
        if (this.isSignatureVerifierEnabled() && !(validSignature = this.signatureVerifier.isValid(req, requestBody))) {
            if (log.isDebugEnabled()) {
                String signature = req.getHeader("X-Slack-Signature");
                log.debug("An invalid X-Slack-Signature detected - {}", (Object)signature);
            }
            resp.setStatus(401);
            return;
        }
        String contentType = req.getHeader("Content-Type");
        if (contentType != null && contentType.toLowerCase(Locale.ENGLISH).trim().startsWith("application/json")) {
            JsonObject payload = ((JsonElement)GsonFactory.createSnakeCase().fromJson(requestBody, JsonElement.class)).getAsJsonObject();
            String eventType = payload.get("type").getAsString();
            if (eventType != null && eventType.equals("url_verification")) {
                String challenge = payload.get("challenge").getAsString();
                resp.setStatus(200);
                resp.setHeader("Content-Type", "text/plain");
                resp.getOutputStream().write(challenge.getBytes(Charset.forName("UTF-8")));
            } else {
                this.dispatcher.enqueue(requestBody);
                resp.setStatus(200);
            }
        } else {
            log.warn("Unexpected request detected - Content-Type: {}", (Object)req.getHeader("Content-Type"));
            resp.setStatus(400);
        }
    }

    protected String getSlackSigningSecret() {
        return System.getenv("SLACK_SIGNING_SECRET");
    }

    protected boolean isSignatureVerifierEnabled() {
        return true;
    }

    protected String doReadRequestBodyAsString(HttpServletRequest req) throws IOException {
        return req.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
    }
}

