/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.blocks.Block;
import notion.api.v1.model.blocks.BlockElementUpdate;
import notion.api.v1.model.blocks.BlockType;
import notion.api.v1.model.blocks.Blocks;
import notion.api.v1.request.blocks.AppendBlockChildrenRequest;
import notion.api.v1.request.blocks.DeleteBlockRequest;
import notion.api.v1.request.blocks.RetrieveBlockChildrenRequest;
import notion.api.v1.request.blocks.RetrieveBlockRequest;
import notion.api.v1.request.blocks.UpdateBlockRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001eH\u0016J-\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020$H\u0016J$\u0010%\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00032\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020*H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lnotion/api/v1/endpoint/BlocksSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "appendBlockChildren", "Lnotion/api/v1/model/blocks/Blocks;", "blockId", "children", "", "Lnotion/api/v1/model/blocks/Block;", "request", "Lnotion/api/v1/request/blocks/AppendBlockChildrenRequest;", "deleteBlock", "", "Lnotion/api/v1/request/blocks/DeleteBlockRequest;", "retrieveBlock", "Lnotion/api/v1/request/blocks/RetrieveBlockRequest;", "retrieveBlockChildren", "startCursor", "pageSize", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lnotion/api/v1/model/blocks/Blocks;", "Lnotion/api/v1/request/blocks/RetrieveBlockChildrenRequest;", "updateBlock", "elements", "", "Lnotion/api/v1/model/blocks/BlockType;", "Lnotion/api/v1/model/blocks/BlockElementUpdate;", "Lnotion/api/v1/request/blocks/UpdateBlockRequest;", "notion-sdk-jvm-core"})
public interface BlocksSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public Block retrieveBlock(@NotNull String var1);

    @NotNull
    public Block retrieveBlock(@NotNull RetrieveBlockRequest var1);

    @NotNull
    public Block updateBlock(@NotNull String var1, @NotNull Map<BlockType, BlockElementUpdate> var2);

    @NotNull
    public Block updateBlock(@NotNull UpdateBlockRequest var1);

    public void deleteBlock(@NotNull String var1);

    public void deleteBlock(@NotNull DeleteBlockRequest var1);

    @NotNull
    public Blocks retrieveBlockChildren(@NotNull String var1, @Nullable String var2, @Nullable Integer var3);

    @NotNull
    public Blocks retrieveBlockChildren(@NotNull RetrieveBlockChildrenRequest var1);

    @NotNull
    public Blocks appendBlockChildren(@NotNull String var1, @NotNull List<? extends Block> var2);

    @NotNull
    public Blocks appendBlockChildren(@NotNull AppendBlockChildrenRequest var1);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Block retrieveBlock(@NotNull BlocksSupport $this, @NotNull String blockId) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            return $this.retrieveBlock(new RetrieveBlockRequest(blockId));
        }

        @NotNull
        public static Block retrieveBlock(@NotNull BlocksSupport $this, @NotNull RetrieveBlockRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.get$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/blocks/" + $this.urlEncode(request.getBlockId()), null, $this.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toBlock(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Block updateBlock(@NotNull BlocksSupport $this, @NotNull String blockId, @NotNull Map<BlockType, BlockElementUpdate> elements) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return $this.updateBlock(new UpdateBlockRequest(blockId, elements, null, null, 12, null));
        }

        @NotNull
        public static Block updateBlock(@NotNull BlocksSupport $this, @NotNull UpdateBlockRequest request) {
            NotionHttpResponse httpResponse;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Map body = new LinkedHashMap();
            for (BlockType key : request.getElements().keySet()) {
                BlockElementUpdate value = request.getElements().get((Object)key);
                if (value == null) continue;
                body.put(key.getValue(), value);
            }
            if (request.getType() != null) {
                body.put("type", request.getType());
            }
            if (request.getArchived() != null) {
                body.put("archived", request.getArchived());
            }
            if ((httpResponse = NotionHttpClient.DefaultImpls.patchTextBody$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/blocks/" + $this.urlEncode(request.getBlockId()), null, $this.getJsonSerializer().toJsonString(body), $this.buildRequestHeaders($this.contentTypeJson()), 4, null)).getStatus() == 200) {
                return $this.getJsonSerializer().toBlock(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        public static void deleteBlock(@NotNull BlocksSupport $this, @NotNull String blockId) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            $this.deleteBlock(new DeleteBlockRequest(blockId));
        }

        public static void deleteBlock(@NotNull BlocksSupport $this, @NotNull DeleteBlockRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.delete$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/blocks/" + $this.urlEncode(request.getBlockId()), null, $this.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() != 200) {
                throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
            }
        }

        @NotNull
        public static Blocks retrieveBlockChildren(@NotNull BlocksSupport $this, @NotNull String blockId, @Nullable String startCursor, @Nullable Integer pageSize) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            return $this.retrieveBlockChildren(new RetrieveBlockChildrenRequest(blockId, startCursor, pageSize));
        }

        public static /* synthetic */ Blocks retrieveBlockChildren$default(BlocksSupport blocksSupport, String string, String string2, Integer n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: retrieveBlockChildren");
            }
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                n = null;
            }
            return blocksSupport.retrieveBlockChildren(string, string2, n);
        }

        @NotNull
        public static Blocks retrieveBlockChildren(@NotNull BlocksSupport $this, @NotNull RetrieveBlockChildrenRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpClient notionHttpClient = $this.getHttpClient();
            NotionLogger notionLogger = $this.getLogger();
            Map<String, List<String>> map = request.toQuery();
            String string = $this.getBaseUrl() + "/blocks/" + $this.urlEncode(request.getBlockId()) + "/children";
            Map<String, String> map2 = $this.buildRequestHeaders(MapsKt.emptyMap());
            NotionHttpResponse httpResponse = notionHttpClient.get(notionLogger, string, map, map2);
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toBlocks(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Blocks appendBlockChildren(@NotNull BlocksSupport $this, @NotNull String blockId, @NotNull List<? extends Block> children) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return $this.appendBlockChildren(new AppendBlockChildrenRequest(blockId, children));
        }

        @NotNull
        public static Blocks appendBlockChildren(@NotNull BlocksSupport $this, @NotNull AppendBlockChildrenRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.patchTextBody$default($this.getHttpClient(), $this.getLogger(), $this.getBaseUrl() + "/blocks/" + request.getBlockId() + "/children", null, $this.getJsonSerializer().toJsonString(request), $this.buildRequestHeaders($this.contentTypeJson()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return $this.getJsonSerializer().toBlocks(httpResponse.getBody());
            }
            throw new NotionAPIError($this.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull BlocksSupport $this, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders($this, additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull BlocksSupport $this, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode($this, value);
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull BlocksSupport $this) {
            return EndpointsSupport.DefaultImpls.contentTypeJson($this);
        }
    }
}

