/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.KeyframesName;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class Keyframes
extends ASTCssNode
implements BodyOwner<GeneralBody> {
    private String dialect;
    private List<KeyframesName> names = new ArrayList<KeyframesName>();
    private GeneralBody body;

    public Keyframes(HiddenTokenAwareTree token, String dialect) {
        super(token);
        this.dialect = dialect;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public List<KeyframesName> getNames() {
        return this.names;
    }

    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(this.names);
        childs.add((KeyframesName)((Object)this.body));
        return childs;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.KEYFRAMES;
    }

    @Override
    public Keyframes clone() {
        Keyframes result = (Keyframes)super.clone();
        result.names = ArraysUtils.deeplyClonedList(this.names);
        result.body = this.body == null ? null : this.body.clone();
        result.configureParentToAllChilds();
        return result;
    }

    public void addNames(List<KeyframesName> names) {
        this.names.addAll(names);
    }
}

