/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.problems;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.SupportsLogicalOperator;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.problems.CompilationError;
import com.github.sommeri.less4j.core.problems.CompilationWarning;
import com.github.sommeri.less4j.core.problems.ProblemsCollector;
import com.github.sommeri.less4j.utils.LessPrinter;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.List;

public class ProblemsHandler {
    private ProblemsCollector collector = new ProblemsCollector();
    private LessPrinter printer = new LessPrinter();

    public void lessjsDoesNotSupportPartiallyInterpolatedMediaQueries(MediaQuery mediaQuery) {
        this.collector.addWarning(new CompilationWarning(mediaQuery, "Usage of less4j only feature - input is incompatible with less.js. Variable can not be used to replace only part of media query, it must contain the whole query."));
    }

    public void wrongMemberInCssBody(ASTCssNode member, Body node) {
        ASTCssNode parent = node.getParent() == null ? node : node.getParent();
        ASTCssNodeType parentType = node.getParent() == null ? ASTCssNodeType.STYLE_SHEET : node.getParent().getType();
        this.collector.addWarning(new CompilationWarning(member, "Compilation resulted in incorrect CSS. The " + PrintUtils.toTypeName(member) + " ended up inside a body of " + PrintUtils.toTypeName(parentType) + " located at " + PrintUtils.toLocation(parent) + "."));
    }

    public void errWrongSupportsLogicalOperator(SupportsLogicalOperator node, String faultyOperator) {
        this.collector.addError(new CompilationError(node, "@supports at rule does not support '" + faultyOperator + "' as a binary logical operator. You can use only 'and' and 'or'."));
    }

    public void wrongMemberInLessBody(ASTCssNode member, Body node) {
        ASTCssNodeType parentType = node.getParent() == null ? ASTCssNodeType.STYLE_SHEET : node.getParent().getType();
        this.collector.addError(new CompilationError(member, "The element " + PrintUtils.toTypeName(member) + " is not allowed to be a " + PrintUtils.toTypeName(parentType) + " member."));
    }

    public void notAColor(ASTCssNode node, String text) {
        this.collector.addError(new CompilationError(node, "The string \"" + text + "\" is not a valid color."));
    }

    public void warnLessjsIncompatibleSelectorAttributeValue(Expression value) {
        this.collector.addWarning(new CompilationWarning(value, "This works, but is incompatible with less.js. Only less.js compatible selector attribute values are string, number and identifier."));
    }

    public void warnMerginMediaQueryWithMedium(MediaQuery mediaQuery) {
        this.collector.addWarning(new CompilationWarning(mediaQuery, "Attempt to merge media query with a medium. Merge removed medium from inner media query, because the result CSS would be invalid otherwise."));
    }

    public void warnInconsistentSupportsLogicalConditionOperators(SupportsLogicalOperator faulty, SupportsLogicalOperator masterOperator) {
        String faultySymbol = faulty.getOperator().getSymbol();
        String masterSymbol = masterOperator.getOperator().getSymbol();
        this.collector.addWarning(new CompilationWarning(faulty, "CSS specification does not allow mixing of 'and', 'or', and 'not' operators without a layer of parentheses. Operators '" + faultySymbol + "' at " + PrintUtils.toLocation(faulty) + "' and '" + masterSymbol + "' at " + PrintUtils.toLocation(masterOperator) + " are in the same layer of parentheses."));
    }

    public void warnLessImportNoBaseDirectory(Expression urlExpression) {
        this.collector.addWarning(new CompilationWarning(urlExpression, "Attempt to import less file with an unknown compiled file location. Import statement left unchanged."));
    }

    public void errorImportedFileCanNotBeRead(Import node, String filename) {
        this.collector.addError(new CompilationError(node, "The file " + filename + " can not be read."));
    }

    public void errorImportedFileNotFound(Import node, String filename) {
        this.collector.addError(new CompilationError(node, "The file " + filename + " does not exist."));
    }

    public void errorWrongImport(Expression urlExpression) {
        this.collector.addError(new CompilationError(urlExpression, "Unsupported @import url kind. File link expression in @import can handle only strings and urls."));
    }

    public void nestedAppenderOnTopLevel(NestedSelectorAppender appender) {
        this.collector.addError(new CompilationError(appender, "Appender symbol is not allowed inside top level rulesets."));
    }

    public void interpolatedMixinReferenceSelector(MixinReference reference) {
        this.collector.addError(new CompilationError(reference.getFinalName(), "Interpolation is not allowed inside mixin references."));
    }

    public void extendedNamespaceReferenceSelector(MixinReference reference) {
        this.collector.addError(new CompilationError(reference, "Structures with extended names can not be used as namespaces."));
    }

    public void interpolatedNamespaceReferenceSelector(MixinReference reference) {
        this.collector.addError(new CompilationError(reference, "Interpolation is not allowed inside namespace references."));
    }

    public void wrongMemberBroughtIntoBody(ASTCssNode reference, ASTCssNode member, ASTCssNode body) {
        ASTCssNode parent = body.getParent() == null ? body : body.getParent();
        this.collector.addError(new CompilationError(reference, "The reference brought " + PrintUtils.toTypeName(member) + " from " + PrintUtils.toLocation(member) + " into " + PrintUtils.toTypeName(parent) + " which started at " + PrintUtils.toLocation(body) + ". Compilation produced an incorrect CSS."));
    }

    public void errFormatWrongFirstParameter(Expression param) {
        this.collector.addError(new CompilationError(param, "First argument of format function must be either string or escaped value."));
    }

    public void wrongNumberOfArgumentsToFunction(Expression param, String function, int expectedArguments) {
        this.collector.addError(new CompilationError(param, "Wrong number of arguments to function '" + function + "', should be " + expectedArguments + "."));
    }

    public void wrongArgumentTypeToFunction(Expression param, String function, ASTCssNodeType received, ASTCssNodeType ... expected) {
        this.collector.addError(new CompilationError(param, "Wrong argument type to function '" + function + "', expected " + PrintUtils.toTypeNames(expected) + " saw " + PrintUtils.toTypeName(received) + "."));
    }

    public void variablesCycle(List<Variable> cycle) {
        this.collector.addError(new CompilationError(cycle.get(0), "Cyclic references among variables: " + this.printer.toVariablesString(cycle)));
    }

    public void mixinsCycle(List<MixinReference> cycle) {
        this.collector.addError(new CompilationError(cycle.get(0), "Cyclic references among mixins: " + this.printer.toMixinReferencesString(cycle)));
    }

    public void deprecatedSyntaxEscapedSelector(EscapedSelector errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Selector fragment (~" + errorNode.getQuoteType() + errorNode.getValue() + errorNode.getQuoteType() + ") uses deprecated (~\"escaped-selector\") syntax. Use selector interpolation @{variableName} instead."));
    }

    public void warnEscapeFunctionArgument(Expression errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Escape function argument should be a string."));
    }

    public void warnExtendInsideExtend(Selector errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Target selector of extend contains nested extend. Nested extend will be ignored. The behaviour of less.js and less4j differ on this type of input."));
    }

    public void warnEFunctionArgument(Expression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "e function argument should be a string."));
    }

    public void variableAsPseudoclassParameter(PseudoClass errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode.getParameter(), "Variables as pseudo classes parameters have been deprecated. Use selector interpolation @{variableName} instead."));
    }

    public void undefinedMixinParameterValue(ReusableStructure mixin, ArgumentDeclaration declaration, MixinReference reference) {
        this.collector.addError(this.createUndefinedMixinParameterValue(mixin, declaration, reference));
    }

    private CompilationError createUndefinedMixinParameterValue(ReusableStructure mixin, ArgumentDeclaration declaration, MixinReference reference) {
        return new CompilationError(reference, "Undefined parameter " + declaration.getVariable().getName() + " of mixin " + reference.getFinalNameAsString() + " defined on line " + mixin.getSourceLine());
    }

    public void undefinedVariable(Variable variable) {
        this.collector.addError(this.createUndefinedVariable(variable.getName(), variable));
    }

    public void undefinedVariable(String name, ASTCssNode ifErrorNode) {
        this.collector.addError(this.createUndefinedVariable(name, ifErrorNode));
    }

    private CompilationError createUndefinedVariable(Variable variable) {
        return this.createUndefinedVariable(variable.getName(), variable);
    }

    private CompilationError createUndefinedVariable(String name, ASTCssNode variable) {
        return new CompilationError(variable, "The variable \"" + name + "\" was not declared.");
    }

    public void undefinedMixin(MixinReference reference) {
        this.collector.addError(this.createUndefinedMixin(reference));
    }

    private CompilationError createUndefinedMixin(MixinReference reference) {
        return this.createUndefinedMixin(reference.getFinalName(), reference);
    }

    private CompilationError createUndefinedMixin(ReusableStructureName name, MixinReference reference) {
        return new CompilationError(reference.getFinalName(), "Could not find mixin named \"" + name.asString() + "\".");
    }

    public void unmatchedMixin(MixinReference reference) {
        this.collector.addError(this.createUnmatchedMixin(reference));
    }

    private CompilationError createUnmatchedMixin(MixinReference reference) {
        return this.createUnmatchedMixin(reference.getFinalName(), reference);
    }

    private CompilationError createUnmatchedMixin(ReusableStructureName name, MixinReference reference) {
        return new CompilationError(reference.getFinalName(), "No mixin named \"" + name.asString() + "\" has the right number of parameters.");
    }

    public void undefinedNamespace(MixinReference reference) {
        this.collector.addError(this.createUndefinedNamespace(reference));
    }

    private CompilationError createUndefinedNamespace(MixinReference reference) {
        return this.createUndefinedNamespace(this.printer.toString(reference), reference);
    }

    private CompilationError createUndefinedNamespace(String name, MixinReference reference) {
        return new CompilationError(reference, "The namespace \"" + name + "\" was not declared.");
    }

    public void nonStringIndirection(Expression errorNode) {
        this.collector.addError(this.createNonStringIndirection(errorNode));
    }

    private CompilationError createNonStringIndirection(Expression errorNode) {
        return new CompilationError(errorNode, "Variable indirection works only with string values.");
    }

    public void nonNumberNegation(SignedExpression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "Cannot negate non number."));
    }

    public void subtractOrDiveColorFromNumber(Expression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "Can't subtract or divide a color from a number"));
    }

    public void mathFunctionParameterNotANumberWarn(String functionName, Expression errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "function '" + functionName + "' requires number as a parameter."));
    }

    public void cannotEvaluate(Expression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "Unable to evaluate expression"));
    }

    public void incompatibleComparisonOperand(Expression errorNode, ComparisonExpressionOperator operator) {
        this.collector.addError(new CompilationError(errorNode, "The operator '" + operator + "' on non-numbers is not defined. The behaviour of less.js and less4j may/does differ. Avoid its use with non-numbers or use one of `istype(@arument)` functions to protect against mismatches: `when (isnumber(@var)) and (@var " + operator + " ...)`. The operator is located at position " + PrintUtils.toLocation(operator) + "."));
    }

    public void rulesetWithoutSelector(RuleSet errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Ruleset without selector encountered."));
    }

    public void divisionByZero(NumberExpression errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Division by zero."));
    }

    public boolean hasErrors() {
        return this.collector.hasErrors();
    }

    public boolean hasWarnings() {
        return this.collector.hasWarnings();
    }

    public List<LessCompiler.Problem> getWarnings() {
        return this.collector.getWarnings();
    }

    public List<LessCompiler.Problem> getErrors() {
        return this.collector.getErrors();
    }

    public void addErrors(List<LessCompiler.Problem> errors) {
        this.collector.addErrors(errors);
    }
}

