/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.common.impl;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RqueueLockManagerImpl
implements RqueueLockManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueLockManagerImpl.class);
    private final RqueueStringDao rqueueStringDao;

    public RqueueLockManagerImpl(RqueueStringDao rqueueStringDao) {
        this.rqueueStringDao = rqueueStringDao;
    }

    @Override
    public boolean acquireLock(String lockKey, String lockValue, Duration duration) {
        Assert.hasText((String)lockKey, (String)"key cannot be null.");
        Assert.hasText((String)lockValue, (String)"value cannot be null.");
        Boolean result = this.rqueueStringDao.setIfAbsent(lockKey, lockValue, duration);
        return Boolean.TRUE.equals(result);
    }

    @Override
    public boolean releaseLock(String lockKey, String lockValue) {
        Assert.hasText((String)lockKey, (String)"key cannot be null.");
        Assert.hasText((String)lockValue, (String)"value cannot be null.");
        Boolean result = this.rqueueStringDao.deleteIfSame(lockKey, lockValue);
        if (!Boolean.TRUE.equals(result)) {
            log.error("release lock failed, key: {}, value: {}", (Object)lockKey, (Object)lockValue);
        }
        return Boolean.TRUE.equals(result);
    }
}

