/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.sonus21.rqueue.utils.SerializationUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class JsonMessageConverter
implements MessageConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonMessageConverter.class);
    private final ObjectMapper objectMapper;

    public JsonMessageConverter() {
        this.objectMapper = SerializationUtils.createObjectMapper();
    }

    public JsonMessageConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
        this.objectMapper = objectMapper;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        log.trace("Message: {} TargetClass: {}", message.getPayload(), targetClass);
        try {
            String payload = (String)message.getPayload();
            if (targetClass == null) {
                return null;
            }
            if (SerializationUtils.isJson(payload)) {
                return this.objectMapper.readValue(payload, targetClass);
            }
            return null;
        }
        catch (JsonProcessingException | ClassCastException e) {
            log.debug("Deserialization of message {} failed", message, (Object)e);
            return null;
        }
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        log.trace("Payload: {} Headers: {}", payload, (Object)headers);
        try {
            String msg = this.objectMapper.writeValueAsString(payload);
            return new GenericMessage((Object)msg);
        }
        catch (JsonProcessingException e) {
            log.debug("Serialisation failed, Payload: {}", payload, (Object)e);
            return null;
        }
    }
}

