/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.converter;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.sonus21.rqueue.utils.SerializationUtils;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.support.NullValue;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class RqueueRedisSerializer
implements RedisSerializer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueRedisSerializer.class);
    private final RedisSerializer<Object> serializer;

    public RqueueRedisSerializer(RedisSerializer<Object> redisSerializer) {
        this.serializer = redisSerializer;
    }

    public RqueueRedisSerializer() {
        this(new RqueueRedisSerDes());
    }

    public byte[] serialize(Object t) throws SerializationException {
        return this.serializer.serialize(t);
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.serializer.deserialize(bytes);
        }
        catch (Exception e) {
            log.warn("Deserialization has failed {}", (Object)new String(bytes), (Object)e);
            return new String(bytes);
        }
    }

    private static class RqueueRedisSerDes
    implements RedisSerializer<Object> {
        private ObjectMapper mapper = this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);

        RqueueRedisSerDes() {
        }

        public byte[] serialize(Object source) throws SerializationException {
            if (source == null) {
                return SerializationUtils.EMPTY_ARRAY;
            }
            try {
                return this.mapper.writeValueAsBytes(source);
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("Could not write JSON: " + e.getMessage(), (Throwable)e);
            }
        }

        public Object deserialize(byte[] source) throws SerializationException {
            if (SerializationUtils.isEmpty(source)) {
                return null;
            }
            try {
                return this.mapper.readValue(source, Object.class);
            }
            catch (Exception ex) {
                throw new SerializationException("Could not read JSON: " + ex.getMessage(), (Throwable)ex);
            }
        }

        private static class NullValueSerializer
        extends StdSerializer<NullValue> {
            private static final long serialVersionUID = 211020517180777825L;
            private final String classIdentifier;

            NullValueSerializer() {
                super(NullValue.class);
                this.classIdentifier = "@class";
            }

            public void serialize(NullValue value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField(this.classIdentifier, NullValue.class.getName());
                jsonGenerator.writeEndObject();
            }
        }
    }
}

