/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.utils.PriorityUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;

public interface ReactiveRqueueMessageEnqueuer {
    public Mono<String> enqueue(String var1, Object var2);

    public Mono<Boolean> enqueue(String var1, String var2, Object var3);

    public Mono<Boolean> enqueueUnique(String var1, String var2, Object var3);

    public Mono<String> enqueueWithRetry(String var1, Object var2, int var3);

    public Mono<Boolean> enqueueWithRetry(String var1, String var2, Object var3, int var4);

    public Mono<String> enqueueWithPriority(String var1, String var2, Object var3);

    public Mono<Boolean> enqueueWithPriority(String var1, String var2, String var3, Object var4);

    default public Mono<Boolean> enqueueUniqueWithPriority(String queueName, String priority, String messageId, Object message) {
        return this.enqueueUnique(PriorityUtils.getQueueNameForPriority(queueName, priority), messageId, message);
    }

    public Mono<String> enqueueIn(String var1, Object var2, long var3);

    public Mono<Boolean> enqueueIn(String var1, String var2, Object var3, long var4);

    default public Mono<String> enqueueIn(String queueName, Object message, Duration delay) {
        return this.enqueueIn(queueName, message, delay.toMillis());
    }

    default public Mono<Boolean> enqueueIn(String queueName, String messageId, Object message, Duration delay) {
        return this.enqueueIn(queueName, messageId, message, delay.toMillis());
    }

    default public Mono<String> enqueueIn(String queueName, Object message, long delay, TimeUnit unit) {
        return this.enqueueIn(queueName, message, unit.toMillis(delay));
    }

    default public Mono<Boolean> enqueueIn(String queueName, String messageId, Object message, long delay, TimeUnit unit) {
        return this.enqueueIn(queueName, messageId, message, unit.toMillis(delay));
    }

    public Mono<Boolean> enqueueUniqueIn(String var1, String var2, Object var3, long var4);

    public Mono<String> enqueueInWithRetry(String var1, Object var2, int var3, long var4);

    public Mono<Boolean> enqueueInWithRetry(String var1, String var2, Object var3, int var4, long var5);

    default public Mono<String> enqueueInWithPriority(String queueName, String priority, Object message, long delayInMilliSecs) {
        return this.enqueueIn(PriorityUtils.getQueueNameForPriority(queueName, priority), message, delayInMilliSecs);
    }

    default public Mono<Boolean> enqueueInWithPriority(String queueName, String priority, String messageId, Object message, long delayInMilliSecs) {
        return this.enqueueIn(PriorityUtils.getQueueNameForPriority(queueName, priority), messageId, message, delayInMilliSecs);
    }

    default public Mono<String> enqueueInWithPriority(String queueName, String priority, Object message, Duration delay) {
        return this.enqueueInWithPriority(queueName, priority, message, delay.toMillis());
    }

    default public Mono<Boolean> enqueueInWithPriority(String queueName, String priority, String messageId, Object message, Duration delay) {
        return this.enqueueInWithPriority(queueName, priority, messageId, message, delay.toMillis());
    }

    default public Mono<String> enqueueInWithPriority(String queueName, String priority, Object message, long delay, TimeUnit unit) {
        return this.enqueueInWithPriority(queueName, priority, message, unit.toMillis(delay));
    }

    default public Mono<Boolean> enqueueInWithPriority(String queueName, String priority, String messageId, Object message, long delay, TimeUnit unit) {
        return this.enqueueInWithPriority(queueName, priority, messageId, message, unit.toMillis(delay));
    }

    default public Mono<Boolean> enqueueUniqueInWithPriority(String queueName, String priority, String messageId, Object message, long delay, TimeUnit unit) {
        return this.enqueueUniqueIn(PriorityUtils.getQueueNameForPriority(queueName, priority), messageId, message, unit.toMillis(delay));
    }

    default public Mono<String> enqueueAt(String queueName, Object message, long startTimeInMilliSeconds) {
        return this.enqueueIn(queueName, message, startTimeInMilliSeconds - System.currentTimeMillis());
    }

    default public Mono<Boolean> enqueueAt(String queueName, String messageId, Object message, long startTimeInMilliSeconds) {
        return this.enqueueIn(queueName, messageId, message, startTimeInMilliSeconds - System.currentTimeMillis());
    }

    default public Mono<String> enqueueAt(String queueName, Object message, Instant starTime) {
        return this.enqueueAt(queueName, message, starTime.toEpochMilli());
    }

    default public Mono<Boolean> enqueueAt(String queueName, String messageId, Object message, Instant starTime) {
        return this.enqueueAt(queueName, messageId, message, starTime.toEpochMilli());
    }

    default public Mono<String> enqueueAt(String queueName, Object message, Date starTime) {
        return this.enqueueAt(queueName, message, starTime.toInstant());
    }

    default public Mono<Boolean> enqueueAt(String queueName, String messageId, Object message, Date starTime) {
        return this.enqueueAt(queueName, messageId, message, starTime.toInstant());
    }

    default public Mono<Boolean> enqueueUniqueAt(String queueName, String messageId, Object message, long timeInMilliSeconds) {
        return this.enqueueUniqueIn(queueName, messageId, message, timeInMilliSeconds - System.currentTimeMillis());
    }

    default public Mono<String> enqueueAtWithPriority(String queueName, String priority, Object message, long startTimeInMilliSecond) {
        return this.enqueueInWithPriority(queueName, priority, message, startTimeInMilliSecond - System.currentTimeMillis());
    }

    default public Mono<Boolean> enqueueAtWithPriority(String queueName, String priority, String messageId, Object message, long startTimeInMilliSecond) {
        return this.enqueueInWithPriority(queueName, priority, messageId, message, startTimeInMilliSecond - System.currentTimeMillis());
    }

    default public Mono<String> enqueueAtWithPriority(String queueName, String priority, Object message, Instant startTime) {
        return this.enqueueAtWithPriority(queueName, priority, message, startTime.toEpochMilli());
    }

    default public Mono<Boolean> enqueueAtWithPriority(String queueName, String priority, String messageId, Object message, Instant instant) {
        return this.enqueueAtWithPriority(queueName, priority, messageId, message, instant.toEpochMilli());
    }

    default public Mono<String> enqueueAtWithPriority(String queueName, String priority, Object message, Date time) {
        return this.enqueueAtWithPriority(queueName, priority, message, time.toInstant());
    }

    default public Mono<Boolean> enqueueAtWithPriority(String queueName, String priority, String messageId, Object message, Date time) {
        return this.enqueueAtWithPriority(queueName, priority, messageId, message, time.toInstant());
    }

    default public Mono<Boolean> enqueueUniqueAtWithPriority(String queueName, String priority, String messageId, Object message, long timeInMilliSeconds) {
        return this.enqueueUniqueInWithPriority(queueName, priority, messageId, message, timeInMilliSeconds - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public Mono<String> enqueuePeriodic(String var1, Object var2, long var3);

    default public Mono<String> enqueuePeriodic(String queueName, Object message, long period, TimeUnit unit) {
        return this.enqueuePeriodic(queueName, message, unit.toMillis(period));
    }

    default public Mono<String> enqueuePeriodic(String queueName, Object message, Duration period) {
        return this.enqueuePeriodic(queueName, message, period.toMillis());
    }

    public Mono<Boolean> enqueuePeriodic(String var1, String var2, Object var3, long var4);

    default public Mono<Boolean> enqueuePeriodic(String queueName, String messageId, Object message, long period, TimeUnit unit) {
        return this.enqueuePeriodic(queueName, messageId, message, unit.toMillis(period));
    }

    default public Mono<Boolean> enqueuePeriodic(String queueName, String messageId, Object message, Duration period) {
        return this.enqueuePeriodic(queueName, messageId, message, period.toMillis());
    }
}

