/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import java.util.List;
import lombok.Generated;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisScriptFactory {
    public static <T> RedisScript<T> getScript(ScriptType type) {
        ClassPathResource resource = new ClassPathResource(type.getPath());
        DefaultRedisScript script = new DefaultRedisScript();
        script.setLocation((Resource)resource);
        switch (type.ordinal()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                script.setResultType(Long.class);
                return script;
            }
            case 10: 
            case 11: {
                script.setResultType(Boolean.class);
                return script;
            }
            case 1: {
                script.setResultType(List.class);
                return script;
            }
        }
        throw new UnknownSwitchCase(type.toString());
    }

    @Generated
    public String toString() {
        return "RedisScriptFactory()";
    }

    public static enum ScriptType {
        ENQUEUE_MESSAGE("rqueue/scripts/enqueue_message.lua"),
        DEQUEUE_MESSAGE("rqueue/scripts/dequeue_message.lua"),
        MOVE_MESSAGE_TO_ZSET("rqueue/scripts/move_message_zset.lua"),
        MOVE_MESSAGE_TO_LIST("rqueue/scripts/move_message_list.lua"),
        MOVE_EXPIRED_MESSAGE("rqueue/scripts/move_expired_message.lua"),
        MOVE_MESSAGE_LIST_TO_LIST("rqueue/scripts/move_message_list_to_list.lua"),
        MOVE_MESSAGE_LIST_TO_ZSET("rqueue/scripts/move_message_list_to_zset.lua"),
        MOVE_MESSAGE_ZSET_TO_ZSET("rqueue/scripts/move_message_zset_to_zset.lua"),
        MOVE_MESSAGE_ZSET_TO_LIST("rqueue/scripts/move_message_zset_to_list.lua"),
        SCHEDULE_MESSAGE("rqueue/scripts/schedule_message.lua"),
        DELETE_IF_SAME("rqueue/scripts/delete_if_same.lua"),
        SCORE_UPDATER("rqueue/scripts/score_updater.lua");

        private final String path;

        private ScriptType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

