/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueSchedulerConfig;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public class RqueueRedisListenerContainerFactory
implements DisposableBean,
SmartLifecycle,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueRedisListenerContainerFactory.class);
    @Autowired
    private RqueueSchedulerConfig rqueueSchedulerConfig;
    @Autowired
    private RqueueConfig rqueueConfig;
    @Autowired(required=false)
    private RedisMessageListenerContainer systemContainer;
    private RedisMessageListenerContainer container;
    private boolean sharedContainer = false;

    public void destroy() throws Exception {
        if (this.notSharedContainer()) {
            this.container.destroy();
        }
    }

    public void start() {
        if (this.notSharedContainer()) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.notSharedContainer()) {
            this.container.stop();
        }
    }

    public boolean isRunning() {
        if (this.container != null) {
            return this.container.isRunning();
        }
        return false;
    }

    private RedisMessageListenerContainer getContainer() {
        return this.container;
    }

    public void addMessageListener(MessageListener listener, Topic topic) {
        this.getContainer().addMessageListener(listener, topic);
    }

    private boolean notSharedContainer() {
        return this.container != null && !this.sharedContainer;
    }

    private void createContainer() {
        this.container = new RedisMessageListenerContainer();
        this.container.setConnectionFactory(this.rqueueConfig.getConnectionFactory());
        this.container.afterPropertiesSet();
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.rqueueConfig.isSharedConnection()) {
            this.createContainer();
            return;
        }
        if (this.rqueueSchedulerConfig.isListenerShared() && this.systemContainer != null) {
            this.container = this.systemContainer;
            this.sharedContainer = true;
            return;
        }
        this.createContainer();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void removeMessageListener(MessageListener messageListener, ChannelTopic channelTopic) {
        this.getContainer().removeMessageListener(messageListener, (Topic)channelTopic);
    }
}

