/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.core.RqueueMessageEnqueuer;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.BaseMessageSender;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;

public class RqueueMessageEnqueuerImpl
extends BaseMessageSender
implements RqueueMessageEnqueuer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageEnqueuerImpl.class);

    public RqueueMessageEnqueuerImpl(RqueueMessageTemplate messageTemplate, MessageConverter messageConverter, MessageHeaders messageHeaders) {
        super(messageTemplate, messageConverter, messageHeaders);
    }

    private void validateBasic(String queue, Object message) {
        Validator.validateQueue(queue);
        Validator.validateMessage(message);
    }

    private void validateWithId(String queue, String messageId, Object message) {
        Validator.validateQueue(queue);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
    }

    @Override
    public String enqueue(String queueName, Object message) {
        this.validateBasic(queueName, message);
        return this.pushMessage(queueName, null, message, null, null, false);
    }

    @Override
    public boolean enqueue(String queueName, String messageId, Object message) {
        this.validateWithId(queueName, messageId, message);
        return this.pushMessage(queueName, messageId, message, null, null, false) != null;
    }

    @Override
    public boolean enqueueUnique(String queueName, String messageId, Object message) {
        this.validateWithId(queueName, messageId, message);
        return Objects.nonNull(this.pushMessage(queueName, messageId, message, null, null, true));
    }

    @Override
    public String enqueueWithRetry(String queueName, Object message, int retryCount) {
        this.validateBasic(queueName, message);
        Validator.validateRetryCount(retryCount);
        return this.pushMessage(queueName, null, message, retryCount, null, false);
    }

    @Override
    public boolean enqueueWithRetry(String queueName, String messageId, Object message, int retryCount) {
        this.validateWithId(queueName, messageId, message);
        Validator.validateRetryCount(retryCount);
        return this.pushMessage(queueName, messageId, message, retryCount, null, false) != null;
    }

    @Override
    public String enqueueWithPriority(String queueName, String priority, Object message) {
        this.validateBasic(queueName, message);
        Validator.validatePriority(priority);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), null, message, null, null, false);
    }

    @Override
    public boolean enqueueWithPriority(String queueName, String priority, String messageId, Object message) {
        this.validateWithId(queueName, messageId, message);
        Validator.validatePriority(priority);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), messageId, message, null, null, false) != null;
    }

    @Override
    public String enqueueIn(String queueName, Object message, long delayInMilliSecs) {
        this.validateBasic(queueName, message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, null, message, null, delayInMilliSecs, false);
    }

    @Override
    public boolean enqueueIn(String queueName, String messageId, Object message, long delayInMilliSecs) {
        this.validateWithId(queueName, messageId, message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, messageId, message, null, delayInMilliSecs, false) != null;
    }

    @Override
    public boolean enqueueUniqueIn(String queueName, String messageId, Object message, long delayInMilliSecs) {
        this.validateWithId(queueName, messageId, message);
        Validator.validateDelay(delayInMilliSecs);
        return Objects.nonNull(this.pushMessage(queueName, messageId, message, null, delayInMilliSecs, true));
    }

    @Override
    public String enqueueInWithRetry(String queueName, Object message, int retryCount, long delayInMilliSecs) {
        this.validateBasic(queueName, message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, null, message, retryCount, delayInMilliSecs, false);
    }

    @Override
    public boolean enqueueInWithRetry(String queueName, String messageId, Object message, int retryCount, long delayInMilliSecs) {
        this.validateWithId(queueName, messageId, message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, messageId, message, retryCount, delayInMilliSecs, false) != null;
    }

    @Override
    public String enqueuePeriodic(String queueName, Object message, long period) {
        this.validateBasic(queueName, message);
        Validator.validatePeriod(period);
        return this.pushPeriodicMessage(queueName, null, message, period);
    }

    @Override
    public boolean enqueuePeriodic(String queueName, String messageId, Object message, long period) {
        this.validateWithId(queueName, messageId, message);
        Validator.validatePeriod(period);
        return this.pushPeriodicMessage(queueName, messageId, message, period) != null;
    }

    @Override
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }
}

