/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageManager;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.BaseMessageSender;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageHeaders;
import com.github.sonus21.rqueue.models.MessageMoveResult;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class RqueueMessageManagerImpl
extends BaseMessageSender
implements RqueueMessageManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageManagerImpl.class);
    @Autowired
    private RqueueLockManager rqueueLockManager;

    public RqueueMessageManagerImpl(RqueueMessageTemplate messageTemplate, MessageConverter messageConverter, MessageHeaders messageHeaders) {
        super(messageTemplate, messageConverter, messageHeaders);
    }

    @Override
    public boolean deleteAllMessages(String queueName) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        try {
            this.deleteAllMessages(queueDetail);
            return true;
        }
        catch (Exception e) {
            log.error("Delete all message failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public List<Object> getAllMessages(String queueName) {
        ArrayList<Object> messages = new ArrayList<Object>();
        for (RqueueMessage message : this.getAllRqueueMessage(queueName)) {
            messages.add(RqueueMessageUtils.convertMessageToObject(message, this.messageConverter));
        }
        return messages;
    }

    @Override
    public Object getMessage(String queueName, String id) {
        RqueueMessage rqueueMessage = this.getRqueueMessage(queueName, id);
        if (rqueueMessage == null) {
            return null;
        }
        Message message = MessageBuilder.createMessage((Object)rqueueMessage.getMessage(), (MessageHeaders)RqueueMessageHeaders.emptyMessageHeaders());
        return this.messageConverter.fromMessage(message, null);
    }

    @Override
    public RqueueMessage getRqueueMessage(String queueName, String id) {
        MessageMetadata messageMetadata = this.rqueueMessageMetadataService.getByMessageId(queueName, id);
        if (messageMetadata == null) {
            return null;
        }
        return messageMetadata.getRqueueMessage();
    }

    @Override
    public List<RqueueMessage> getAllRqueueMessage(String queueName) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        return this.messageTemplate.getAllMessages(queueDetail.getQueueName(), queueDetail.getProcessingQueueName(), queueDetail.getScheduledQueueName());
    }

    @Override
    public boolean exist(String queueName, String id) {
        return this.getMessage(queueName, id) != null;
    }

    @Override
    public boolean deleteMessage(String queueName, String id) {
        RqueueMessage rqueueMessage = this.getRqueueMessage(queueName, id);
        if (rqueueMessage == null) {
            log.error("Delete message failed, no such message: {}", (Object)id);
            return false;
        }
        Duration duration = this.rqueueConfig.getMessageDurability(rqueueMessage.getPeriod());
        return this.rqueueMessageMetadataService.deleteMessage(queueName, id, duration);
    }

    @Override
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    @Override
    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName, Integer maxMessages) {
        return this.moveMessageListToList(deadLetterQueueName, queueName, maxMessages).isSuccess();
    }

    @Override
    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName) {
        return this.moveMessageListToList(deadLetterQueueName, queueName, null).isSuccess();
    }

    private MessageMoveResult moveMessageListToList(String sourceQueue, String destinationQueue, Integer maxMessage) {
        Assert.notNull((Object)sourceQueue, (String)"sourceQueue must not be null");
        Assert.notNull((Object)destinationQueue, (String)"destinationQueue must not be null");
        Assert.isTrue((!sourceQueue.equals(destinationQueue) ? 1 : 0) != 0, (String)"sourceQueue and destinationQueue must be different");
        Integer messageCount = maxMessage;
        if (messageCount == null) {
            messageCount = 100;
        }
        Assert.isTrue((messageCount > 0 ? 1 : 0) != 0, (String)"maxMessage must be greater than zero");
        return this.messageTemplate.moveMessageListToList(sourceQueue, destinationQueue, messageCount);
    }
}

