/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.common.ReactiveRqueueRedisTemplate;
import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.core.RedisScriptFactory;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.models.MessageMoveResult;
import com.github.sonus21.rqueue.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.DefaultReactiveScriptExecutor;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.ReactiveScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RqueueMessageTemplateImpl
extends RqueueRedisTemplate<RqueueMessage>
implements RqueueMessageTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageTemplateImpl.class);
    private final DefaultScriptExecutor<String> scriptExecutor;
    private final ReactiveScriptExecutor<String> reactiveScriptExecutor;
    private final ReactiveRqueueRedisTemplate<RqueueMessage> reactiveRedisTemplate;

    public RqueueMessageTemplateImpl(RedisConnectionFactory redisConnectionFactory, ReactiveRedisConnectionFactory reactiveRedisConnectionFactory) {
        super(redisConnectionFactory);
        this.scriptExecutor = new DefaultScriptExecutor(this.redisTemplate);
        if (reactiveRedisConnectionFactory != null) {
            this.reactiveRedisTemplate = new ReactiveRqueueRedisTemplate(reactiveRedisConnectionFactory);
            this.reactiveScriptExecutor = new DefaultReactiveScriptExecutor(reactiveRedisConnectionFactory, RedisUtils.redisSerializationContextProvider.getSerializationContext());
        } else {
            this.reactiveScriptExecutor = null;
            this.reactiveRedisTemplate = null;
        }
    }

    @Override
    public List<RqueueMessage> pop(String queueName, String processingQueueName, String processingChannelName, long visibilityTimeout, int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Count must be greater than or equal to 1");
        }
        long currentTime = System.currentTimeMillis();
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.DEQUEUE_MESSAGE);
        List messages = (List)this.scriptExecutor.execute(script, Arrays.asList(queueName, processingQueueName, processingChannelName), new Object[]{currentTime, currentTime + visibilityTimeout, count});
        log.debug("Pop Queue: {}, N: {}, Messages: {}", new Object[]{queueName, count, messages});
        return messages;
    }

    @Override
    public Long addMessageWithDelay(String delayQueueName, String delayQueueChannelName, RqueueMessage rqueueMessage) {
        log.debug("AddMessageWithDelay Queue: {}, Message: {}", (Object)delayQueueName, (Object)rqueueMessage);
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.ENQUEUE_MESSAGE);
        return (Long)this.scriptExecutor.execute(script, Arrays.asList(delayQueueName, delayQueueChannelName), new Object[]{rqueueMessage, rqueueMessage.getProcessAt(), System.currentTimeMillis()});
    }

    @Override
    public Flux<Long> addReactiveMessageWithDelay(String scheduledQueueName, String scheduledQueueChannelName, RqueueMessage rqueueMessage) {
        log.debug("AddReactiveMessageWithDelay Queue: {}, Message: {}", (Object)scheduledQueueName, (Object)rqueueMessage);
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.ENQUEUE_MESSAGE);
        return this.reactiveScriptExecutor.execute(script, Arrays.asList(scheduledQueueName, scheduledQueueChannelName), Arrays.asList(rqueueMessage, rqueueMessage.getProcessAt(), System.currentTimeMillis()));
    }

    @Override
    public Long addMessage(String listName, RqueueMessage rqueueMessage) {
        log.debug("AddMessage Queue: {}, Message: {}", (Object)listName, (Object)rqueueMessage);
        return this.rpush(listName, rqueueMessage);
    }

    @Override
    public Mono<Long> addReactiveMessage(String listName, RqueueMessage rqueueMessage) {
        log.debug("AddReactiveMessage Queue: {}, Message: {}", (Object)listName, (Object)rqueueMessage);
        return this.reactiveRedisTemplate.template().opsForList().rightPush((Object)listName, (Object)rqueueMessage);
    }

    @Override
    public Boolean addToZset(String zsetName, RqueueMessage rqueueMessage, long score) {
        log.debug("AddToZset Queue: {}, Message: {}", (Object)zsetName, (Object)rqueueMessage);
        return this.zadd(zsetName, rqueueMessage, score);
    }

    @Override
    public void moveMessageWithDelay(String srcZsetName, String tgtZsetName, RqueueMessage src, RqueueMessage tgt, long delay) {
        log.debug("MoveMessageWithDelay Src:[Q={},M={}], Dst:[Q={},M={}]", new Object[]{srcZsetName, src, tgtZsetName, tgt});
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE_TO_ZSET);
        Long response = (Long)this.scriptExecutor.execute(script, Arrays.asList(srcZsetName, tgtZsetName), new Object[]{src, tgt, System.currentTimeMillis() + delay});
        if (response == null) {
            log.error("Duplicate processing for the message {}", (Object)src);
        }
    }

    @Override
    public void moveMessage(String srcZsetName, String tgtListName, RqueueMessage src, RqueueMessage tgt) {
        log.debug("MoveMessage Src:[Q={},M={}], Dst:[Q={},M={}]", new Object[]{srcZsetName, src, tgtListName, tgt});
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE_TO_LIST);
        Long response = (Long)this.scriptExecutor.execute(script, Arrays.asList(srcZsetName, tgtListName), new Object[]{src, tgt});
        if (response == null) {
            log.error("Duplicate processing for the message {}", (Object)src);
        }
    }

    @Override
    public List<RqueueMessage> getAllMessages(String queueName, String processingQueueName, String delayQueueName) {
        Set messagesFromZset;
        Set messagesInProcessingQueue;
        List<RqueueMessage> messages = this.lrange(queueName, 0L, -1L);
        if (CollectionUtils.isEmpty(messages)) {
            messages = new ArrayList();
        }
        if (!CollectionUtils.isEmpty(messagesInProcessingQueue = this.zrange(processingQueueName, 0L, -1L))) {
            messages.addAll(messagesInProcessingQueue);
        }
        if (delayQueueName != null && !CollectionUtils.isEmpty(messagesFromZset = this.zrange(delayQueueName, 0L, -1L))) {
            messages.addAll(messagesFromZset);
        }
        return messages;
    }

    @Override
    public Long getScore(String zsetName, RqueueMessage message) {
        Double score = this.redisTemplate.opsForZSet().score((Object)zsetName, (Object)message);
        if (score == null) {
            return null;
        }
        return score.longValue();
    }

    @Override
    public boolean addScore(String zsetName, RqueueMessage message, long delta) {
        return (Boolean)this.scriptExecutor.execute(RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.SCORE_UPDATER), Collections.singletonList(zsetName), new Object[]{message, delta});
    }

    private MessageMoveResult moveMessageToList(String src, String dst, int maxMessage, RedisScriptFactory.ScriptType scriptType) {
        RedisScript script = RedisScriptFactory.getScript(scriptType);
        long messagesInSrc = maxMessage;
        int remainingMessages = maxMessage;
        while (messagesInSrc > 0L && remainingMessages > 0) {
            long messageCount = Math.min(remainingMessages, 100);
            messagesInSrc = (Long)this.scriptExecutor.execute(script, Arrays.asList(src, dst), new Object[]{messageCount});
            remainingMessages = (int)((long)remainingMessages - messageCount);
        }
        return new MessageMoveResult(maxMessage - remainingMessages, true);
    }

    @Override
    public MessageMoveResult moveMessageListToList(String srcQueueName, String dstQueueName, int numberOfMessage) {
        return this.moveMessageToList(srcQueueName, dstQueueName, numberOfMessage, RedisScriptFactory.ScriptType.MOVE_MESSAGE_LIST_TO_LIST);
    }

    @Override
    public MessageMoveResult moveMessageZsetToList(String sourceZset, String destinationList, int maxMessage) {
        return this.moveMessageToList(sourceZset, destinationList, maxMessage, RedisScriptFactory.ScriptType.MOVE_MESSAGE_ZSET_TO_LIST);
    }

    @Override
    public MessageMoveResult moveMessageListToZset(String sourceList, String destinationZset, int maxMessage, long score) {
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE_LIST_TO_ZSET);
        long messagesInList = maxMessage;
        int remainingMessages = maxMessage;
        while (messagesInList > 0L && remainingMessages > 0) {
            long messageCount = Math.min(remainingMessages, 100);
            messagesInList = (Long)this.scriptExecutor.execute(script, Arrays.asList(sourceList, destinationZset), new Object[]{messageCount, score});
            remainingMessages = (int)((long)remainingMessages - messageCount);
        }
        return new MessageMoveResult(maxMessage - remainingMessages, true);
    }

    @Override
    public MessageMoveResult moveMessageZsetToZset(String sourceZset, String destinationZset, int maxMessage, long newScore, boolean fixedScore) {
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE_ZSET_TO_ZSET);
        long messageInZset = maxMessage;
        int remainingMessages = maxMessage;
        while (messageInZset > 0L && remainingMessages > 0) {
            long messageCount = Math.min(remainingMessages, 100);
            messageInZset = (Long)this.scriptExecutor.execute(script, Arrays.asList(sourceZset, destinationZset), new Object[]{messageCount, newScore, fixedScore});
            remainingMessages = (int)((long)remainingMessages - messageCount);
        }
        return new MessageMoveResult(maxMessage - remainingMessages, true);
    }

    @Override
    public List<RqueueMessage> readFromZset(String name, long start, long end) {
        Set messages = this.zrange(name, start, end);
        if (messages == null) {
            return new ArrayList<RqueueMessage>();
        }
        return new ArrayList<RqueueMessage>(messages);
    }

    @Override
    public List<ZSetOperations.TypedTuple<RqueueMessage>> readFromZsetWithScore(String name, long start, long end) {
        Set messages = this.zrangeWithScore(name, start, end);
        if (messages == null) {
            return new ArrayList<ZSetOperations.TypedTuple<RqueueMessage>>();
        }
        return new ArrayList<ZSetOperations.TypedTuple<RqueueMessage>>(messages);
    }

    @Override
    public Long scheduleMessage(String zsetName, String messageId, RqueueMessage rqueueMessage, Long expiryInSeconds) {
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.SCHEDULE_MESSAGE);
        return (Long)this.scriptExecutor.execute(script, Arrays.asList(messageId, zsetName), new Object[]{expiryInSeconds, rqueueMessage, rqueueMessage.getProcessAt()});
    }

    @Override
    public boolean renameCollection(String srcName, String tgtName) {
        this.rename(srcName, tgtName);
        return true;
    }

    @Override
    public boolean renameCollections(List<String> srcNames, List<String> tgtNames) {
        this.rename(srcNames, tgtNames);
        return true;
    }

    @Override
    public void deleteCollection(String name) {
        this.redisTemplate.delete((Object)name);
    }

    @Override
    public List<RqueueMessage> readFromList(String name, long start, long end) {
        List<RqueueMessage> messages = this.lrange(name, start, end);
        if (messages == null) {
            return new ArrayList<RqueueMessage>();
        }
        return messages;
    }

    @Override
    public RedisTemplate<String, RqueueMessage> getTemplate() {
        return this.redisTemplate;
    }

    @Override
    public Long removeElementFromZset(String zsetName, RqueueMessage rqueueMessage) {
        return super.removeFromZset(zsetName, rqueueMessage);
    }
}

