/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.middleware;

import com.github.sonus21.rqueue.core.Job;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.middleware.Middleware;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.RqueueMessageHeaders;
import com.github.sonus21.rqueue.models.db.Execution;
import java.util.concurrent.Callable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

public class HandlerMiddleware
implements Middleware {
    private final RqueueMessageHandler rqueueMessageHandler;

    public HandlerMiddleware(RqueueMessageHandler rqueueMessageHandler) {
        this.rqueueMessageHandler = rqueueMessageHandler;
    }

    @Override
    public void handle(Job job, Callable<Void> next) throws Exception {
        Execution execution = job.getLatestExecution();
        RqueueMessage rqueueMessage = job.getRqueueMessage();
        Message message = MessageBuilder.createMessage((Object)rqueueMessage.getMessage(), (MessageHeaders)RqueueMessageHeaders.buildMessageHeaders(job.getQueueDetail().getName(), rqueueMessage, job, execution, rqueueMessage.getMessageHeaders()));
        this.rqueueMessageHandler.handleMessage(message);
    }
}

