/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.support;

import com.github.sonus21.rqueue.core.RqueueMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;

public final class RqueueMessageUtils {
    private static final String META_DATA_KEY_PREFIX = "__rq::m-mdata::";

    private RqueueMessageUtils() {
    }

    public static String getMessageMetaId(String queueName, String messageId) {
        return META_DATA_KEY_PREFIX + queueName + "::" + messageId;
    }

    public static Object convertMessageToObject(RqueueMessage message, MessageConverter messageConverter) {
        return RqueueMessageUtils.convertMessageToObject((Message<String>)new GenericMessage((Object)message.getMessage()), messageConverter);
    }

    public static Object convertMessageToObject(Message<String> message, MessageConverter messageConverter) {
        return messageConverter.fromMessage(message, null);
    }

    public static RqueueMessage buildPeriodicMessage(MessageConverter converter, String queueName, String messageId, Object message, Integer retryCount, long period, MessageHeaders messageHeaders) {
        String strMessage;
        Message msg = converter.toMessage(message, messageHeaders);
        if (msg == null) {
            throw new MessageConversionException("Message could not be build (null)");
        }
        Object payload = msg.getPayload();
        long processAt = System.currentTimeMillis() + period;
        if (payload instanceof String) {
            strMessage = (String)payload;
        } else if (payload instanceof byte[]) {
            strMessage = new String((byte[])payload);
        } else {
            throw new MessageConversionException("Message payload is neither String nor byte[]");
        }
        RqueueMessage rqueueMessage = RqueueMessage.builder().id(UUID.randomUUID().toString()).queueName(queueName).message(strMessage).processAt(processAt).retryCount(retryCount).period(period).build();
        if (messageId != null) {
            rqueueMessage.setId(messageId);
        }
        return rqueueMessage;
    }

    public static RqueueMessage buildMessage(MessageConverter converter, String queueName, String messageId, Object message, Integer retryCount, Long delay, MessageHeaders messageHeaders) {
        String strMessage;
        Object payload;
        Message msg = converter.toMessage(message, messageHeaders);
        if (msg == null) {
            throw new MessageConversionException("Message could not be build (null)");
        }
        long queuedTime = System.nanoTime();
        long processAt = System.currentTimeMillis();
        if (delay != null) {
            processAt += delay.longValue();
        }
        if ((payload = msg.getPayload()) instanceof String) {
            strMessage = (String)payload;
        } else if (payload instanceof byte[]) {
            strMessage = new String((byte[])payload);
        } else {
            throw new MessageConversionException("Message payload is neither String nor byte[]");
        }
        RqueueMessage rqueueMessage = RqueueMessage.builder().retryCount(retryCount).queuedTime(queuedTime).id(UUID.randomUUID().toString()).queueName(queueName).message(strMessage).processAt(processAt).build();
        if (messageId != null) {
            rqueueMessage.setId(messageId);
        }
        return rqueueMessage;
    }

    public static List<RqueueMessage> generateMessages(MessageConverter converter, String queueName, int count) {
        return RqueueMessageUtils.generateMessages(converter, UUID.randomUUID().toString(), queueName, null, null, count);
    }

    public static RqueueMessage generateMessage(MessageConverter converter, String queueName) {
        return RqueueMessageUtils.generateMessages(converter, UUID.randomUUID().toString(), queueName, null, null, 1).get(0);
    }

    public static List<RqueueMessage> generateMessages(MessageConverter converter, String queueName, long delay, int count) {
        return RqueueMessageUtils.generateMessages(converter, UUID.randomUUID().toString(), queueName, null, delay, count);
    }

    public static List<RqueueMessage> generateMessages(MessageConverter converter, Object object, String queueName, Integer retryCount, Long delay, int count) {
        ArrayList<RqueueMessage> messages = new ArrayList<RqueueMessage>();
        for (int i = 0; i < count; ++i) {
            messages.add(RqueueMessageUtils.buildMessage(converter, queueName, null, object, retryCount, delay, null));
        }
        return messages;
    }

    public static Message<?> cloneMessage(Message<?> message) {
        return new GenericMessage(message.getPayload(), new HashMap(message.getHeaders()));
    }
}

