/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.dao.impl;

import com.github.sonus21.rqueue.common.ReactiveRqueueRedisTemplate;
import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.dao.RqueueMessageMetadataDao;
import com.github.sonus21.rqueue.exception.DuplicateMessageException;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Repository
public class RqueueMessageMetadataDaoImpl
implements RqueueMessageMetadataDao {
    private final RqueueRedisTemplate<MessageMetadata> template;
    private final ReactiveRqueueRedisTemplate<MessageMetadata> reactiveRedisTemplate;

    public RqueueMessageMetadataDaoImpl(RqueueConfig rqueueConfig) {
        this.template = new RqueueRedisTemplate(rqueueConfig.getConnectionFactory());
        this.reactiveRedisTemplate = rqueueConfig.isReactiveEnabled() ? new ReactiveRqueueRedisTemplate(rqueueConfig.getReactiveRedisConnectionFactory()) : null;
    }

    @Override
    public MessageMetadata get(String id) {
        return this.template.get(id);
    }

    @Override
    public List<MessageMetadata> findAll(Collection<String> ids) {
        return this.template.mget(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void save(MessageMetadata messageMetadata, Duration duration, boolean checkUniqueNess) {
        Assert.notNull((Object)messageMetadata.getId(), (String)"messageMetadata id cannot be null");
        if (checkUniqueNess) {
            Boolean value = this.template.setIfAbsent(messageMetadata.getId(), messageMetadata, duration);
            if (Boolean.FALSE.equals(value)) {
                throw new DuplicateMessageException(messageMetadata.getId());
            }
            return;
        }
        this.template.set(messageMetadata.getId(), messageMetadata, duration);
    }

    @Override
    public void delete(String id) {
        this.template.delete(id);
    }

    @Override
    public void deleteAll(Collection<String> ids) {
        this.template.delete(ids);
    }

    @Override
    public Mono<Boolean> saveReactive(MessageMetadata messageMetadata, Duration ttl, boolean isUnique) {
        Assert.notNull((Object)messageMetadata.getId(), (String)"messageMetadata id cannot be null");
        if (isUnique) {
            return this.reactiveRedisTemplate.template().opsForValue().setIfAbsent((Object)messageMetadata.getId(), (Object)messageMetadata, ttl);
        }
        return this.reactiveRedisTemplate.template().opsForValue().set((Object)messageMetadata.getId(), (Object)messageMetadata, ttl);
    }
}

