/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.dao.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.dao.RqueueQStatsDao;
import com.github.sonus21.rqueue.models.db.QueueStatistics;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RqueueQStatsDaoImpl
implements RqueueQStatsDao {
    private final RqueueRedisTemplate<QueueStatistics> rqueueRedisTemplate;

    @Autowired
    public RqueueQStatsDaoImpl(RqueueConfig rqueueConfig) {
        this(new RqueueRedisTemplate<QueueStatistics>(rqueueConfig.getConnectionFactory()));
    }

    public RqueueQStatsDaoImpl(RqueueRedisTemplate<QueueStatistics> rqueueRedisTemplate) {
        this.rqueueRedisTemplate = rqueueRedisTemplate;
    }

    @Override
    public QueueStatistics findById(String id) {
        return this.rqueueRedisTemplate.get(id);
    }

    @Override
    public List<QueueStatistics> findAll(Collection<String> ids) {
        return this.rqueueRedisTemplate.mget(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void save(QueueStatistics queueStatistics) {
        if (queueStatistics == null) {
            throw new IllegalArgumentException("queueStatistics cannot be null");
        }
        if (queueStatistics.getId() == null) {
            throw new IllegalArgumentException("id cannot be null " + String.valueOf(queueStatistics));
        }
        this.rqueueRedisTemplate.set(queueStatistics.getId(), queueStatistics);
    }
}

