/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.dao.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.dao.RqueueSystemConfigDao;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RqueueSystemConfigDaoImpl
implements RqueueSystemConfigDao {
    private final RqueueRedisTemplate<QueueConfig> rqueueRedisTemplate;
    private final Map<String, QueueConfig> queueConfigMap = new ConcurrentHashMap<String, QueueConfig>();
    private final RqueueConfig rqueueConfig;

    @Autowired
    public RqueueSystemConfigDaoImpl(RqueueConfig rqueueConfig) {
        this(new RqueueRedisTemplate<QueueConfig>(rqueueConfig.getConnectionFactory()), rqueueConfig);
    }

    public RqueueSystemConfigDaoImpl(RqueueRedisTemplate<QueueConfig> rqueueRedisTemplate, RqueueConfig rqueueConfig) {
        this.rqueueRedisTemplate = rqueueRedisTemplate;
        this.rqueueConfig = rqueueConfig;
    }

    @Override
    public QueueConfig getConfigByName(String name) {
        return this.getConfigByName(name, false);
    }

    @Override
    public List<QueueConfig> getConfigByNames(Collection<String> names) {
        return this.findAllQConfig(names.stream().map(this.rqueueConfig::getQueueConfigKey).collect(Collectors.toList()));
    }

    @Override
    public QueueConfig getConfigByName(String name, boolean cached) {
        String queueConfigKey = this.rqueueConfig.getQueueConfigKey(name);
        return this.getQConfig(queueConfigKey, cached);
    }

    @Override
    public QueueConfig getQConfig(String id, boolean cached) {
        if (cached && this.queueConfigMap.containsKey(id)) {
            return this.queueConfigMap.get(id);
        }
        QueueConfig queueConfig = this.rqueueRedisTemplate.get(id);
        if (queueConfig != null) {
            this.queueConfigMap.put(id, queueConfig);
        }
        return queueConfig;
    }

    @Override
    public List<QueueConfig> findAllQConfig(Collection<String> ids) {
        return this.rqueueRedisTemplate.mget(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void saveQConfig(QueueConfig queueConfig) {
        this.saveAllQConfig(Collections.singletonList(queueConfig));
    }

    @Override
    public void saveAllQConfig(List<QueueConfig> newConfigs) {
        if (!CollectionUtils.isEmpty(newConfigs)) {
            HashMap<String, QueueConfig> idToQueueConfig = new HashMap<String, QueueConfig>();
            for (QueueConfig queueConfig : newConfigs) {
                if (queueConfig == null) {
                    throw new IllegalArgumentException("queueConfig cannot be null");
                }
                if (queueConfig.getId() == null) {
                    throw new IllegalArgumentException("id cannot be null " + String.valueOf(queueConfig));
                }
                idToQueueConfig.put(queueConfig.getId(), queueConfig);
            }
            for (String key : idToQueueConfig.keySet()) {
                this.queueConfigMap.remove(key);
            }
            this.rqueueRedisTemplate.mset(idToQueueConfig);
            for (String key : idToQueueConfig.keySet()) {
                this.queueConfigMap.remove(key);
            }
        }
    }

    @Override
    public void clearCacheByName(String name) {
        String key = this.rqueueConfig.getQueueConfigKey(name);
        this.queueConfigMap.remove(key);
    }
}

