/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.Job;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.context.Context;
import com.github.sonus21.rqueue.core.context.DefaultContext;
import com.github.sonus21.rqueue.core.middleware.TimeProviderMiddleware;
import com.github.sonus21.rqueue.dao.RqueueJobDao;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.db.Execution;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.db.RqueueJob;
import com.github.sonus21.rqueue.models.enums.ExecutionStatus;
import com.github.sonus21.rqueue.models.enums.JobStatus;
import com.github.sonus21.rqueue.models.enums.MessageStatus;
import com.github.sonus21.rqueue.utils.Constants;
import com.github.sonus21.rqueue.utils.TimeoutUtils;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.util.CollectionUtils;

public class JobImpl
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobImpl.class);
    public final Duration expiry;
    private final RqueueJobDao rqueueJobDao;
    private final RqueueMessageMetadataService messageMetadataService;
    private final RqueueMessageTemplate rqueueMessageTemplate;
    private final RqueueLockManager rqueueLockManager;
    private final RqueueConfig rqueueConfig;
    private final QueueDetail queueDetail;
    private final RqueueJob rqueueJob;
    private final PostProcessingHandler postProcessingHandler;
    private final boolean isPeriodicJob;
    private Object userMessage;
    private Context context = DefaultContext.EMPTY;
    private Boolean released;
    private Boolean deleted;

    public JobImpl(RqueueConfig rqueueConfig, RqueueMessageMetadataService messageMetadataService, RqueueJobDao rqueueJobDao, RqueueMessageTemplate rqueueMessageTemplate, RqueueLockManager rqueueLockManager, QueueDetail queueDetail, MessageMetadata messageMetadata, RqueueMessage rqueueMessage, Object userMessage, PostProcessingHandler postProcessingHandler) {
        this.rqueueJobDao = rqueueJobDao;
        this.messageMetadataService = messageMetadataService;
        this.rqueueConfig = rqueueConfig;
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.queueDetail = queueDetail;
        this.userMessage = userMessage;
        this.postProcessingHandler = postProcessingHandler;
        this.rqueueJob = new RqueueJob(rqueueConfig.getJobId(), rqueueMessage, messageMetadata, null);
        this.expiry = Duration.ofMillis(2L * queueDetail.getVisibilityTimeout());
        this.isPeriodicJob = rqueueMessage.isPeriodic();
        this.rqueueLockManager = rqueueLockManager;
        if (rqueueConfig.isJobEnabled() && !this.isPeriodicJob) {
            rqueueJobDao.createJob(this.rqueueJob, this.expiry);
        }
    }

    private void save() {
        if (this.rqueueConfig.isJobEnabled() && !this.isPeriodicJob) {
            Duration ttl = this.expiry;
            if (this.getMessageMetadata().getStatus().isTerminalState()) {
                ttl = this.rqueueConfig.getJobDurabilityInTerminalState();
            }
            try {
                if (ttl.isNegative() || ttl.isZero()) {
                    this.rqueueJobDao.delete(this.rqueueJob.getId());
                } else {
                    this.rqueueJob.setUpdatedAt(System.currentTimeMillis());
                    this.rqueueJobDao.save(this.rqueueJob, ttl);
                }
            }
            catch (RedisSystemException redisSystemException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getId() {
        return this.rqueueJob.getId();
    }

    @Override
    public String getMessageId() {
        return this.rqueueJob.getMessageId();
    }

    @Override
    public RqueueMessage getRqueueMessage() {
        return this.rqueueJob.getRqueueMessage();
    }

    @Override
    public String getRawMessage() {
        return this.getRqueueMessage().getMessage();
    }

    @Override
    public void checkIn(Serializable message) {
        if (this.isPeriodicJob) {
            throw new UnsupportedOperationException("CheckIn is not supported for periodic job");
        }
        log.debug("Checkin {} Message: {}", (Object)this.rqueueJob.getId(), (Object)message);
        this.rqueueJob.checkIn(message);
        this.save();
    }

    @Override
    public Duration getVisibilityTimeout() {
        Long score = this.rqueueMessageTemplate.getScore(this.queueDetail.getProcessingQueueName(), this.rqueueJob.getRqueueMessage());
        if (score == null || score <= 0L) {
            return Duration.ZERO;
        }
        long remainingTime = score - System.currentTimeMillis();
        return Duration.ofMillis(remainingTime);
    }

    @Override
    public boolean updateVisibilityTimeout(Duration deltaDuration) {
        return this.rqueueMessageTemplate.addScore(this.queueDetail.getProcessingQueueName(), this.rqueueJob.getRqueueMessage(), deltaDuration.toMillis());
    }

    @Override
    public Object getMessage() {
        return this.userMessage;
    }

    @Override
    public void setMessage(Object message) {
        this.userMessage = message;
    }

    @Override
    public MessageMetadata getMessageMetadata() {
        return this.rqueueJob.getMessageMetadata();
    }

    void setMessageMetadata(MessageMetadata m) {
        this.rqueueJob.setMessageMetadata(m);
        this.save();
    }

    @Override
    public JobStatus getStatus() {
        return this.rqueueJob.getStatus();
    }

    @Override
    public Throwable getException() {
        return this.rqueueJob.getException();
    }

    @Override
    public long getExecutionTime() {
        long executionTime = 0L;
        for (Execution execution : this.rqueueJob.getExecutions()) {
            executionTime += execution.getEndTime() - execution.getStartTime();
        }
        return executionTime;
    }

    @Override
    public QueueDetail getQueueDetail() {
        return this.queueDetail;
    }

    @Override
    public Execution getLatestExecution() {
        List<Execution> executions = this.rqueueJob.getExecutions();
        if (CollectionUtils.isEmpty(executions)) {
            return null;
        }
        return executions.get(executions.size() - 1);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context can not be null");
        }
        this.context = context;
    }

    @Override
    public void release(JobStatus jobStatus, Serializable why, Duration duration) {
        this.released = true;
        this.postProcessingHandler.parkMessageForRetry(this, why, this.getFailureCount(), duration.toMillis());
    }

    @Override
    public void release(JobStatus jobStatus, Serializable why) {
        this.release(jobStatus, why, TimeProviderMiddleware.ONE_SECOND);
    }

    @Override
    public void delete(JobStatus status, Serializable why) {
        this.deleted = true;
        this.postProcessingHandler.handleManualDeletion(this, this.getFailureCount());
    }

    @Override
    public boolean isDeleted() {
        if (this.deleted == null) {
            return this.getMessageMetadata().getStatus().isTerminalState();
        }
        return this.deleted;
    }

    @Override
    public boolean isReleased() {
        if (this.released == null) {
            return MessageStatus.FAILED.equals((Object)this.getMessageMetadata().getStatus());
        }
        return this.released;
    }

    @Override
    public boolean hasMovedToDeadLetterQueue() {
        return MessageStatus.MOVED_TO_DLQ.equals((Object)this.getMessageMetadata().getStatus());
    }

    @Override
    public boolean isDiscarded() {
        return MessageStatus.DISCARDED.equals((Object)this.getMessageMetadata().getStatus());
    }

    private void setMessageStatus(MessageStatus messageStatus) {
        this.rqueueJob.setStatus(messageStatus.getJobStatus());
        this.rqueueJob.getMessageMetadata().setStatus(messageStatus);
    }

    @Override
    public int getFailureCount() {
        return this.getFailureCountInternal();
    }

    private int getFailureCountInternal() {
        if (this.isDeleted() || this.isReleased()) {
            return this.getRqueueMessage().getFailureCount() + this.rqueueJob.getExecutions().size();
        }
        return this.getRqueueMessage().getFailureCount();
    }

    private MessageMetadata getLatestMessageMetadata() {
        return this.messageMetadataService.get(this.getMessageMetadata().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMessageMetadata(Callable<Void> callable) {
        if (this.getMessageMetadata().isDeleted()) {
            try {
                callable.call();
            }
            catch (Exception e) {
                log.error("Saving message metadata failed", (Throwable)e);
            }
            return;
        }
        long endTime = System.currentTimeMillis() + 10000L;
        long sleepDuration = 100L;
        Duration lockDuration = Duration.ofSeconds(1L);
        String lockKey = Constants.getMessageLockName(this.rqueueConfig, this.getMessageId());
        String lockValue = UUID.randomUUID().toString();
        while (System.currentTimeMillis() < endTime) {
            if (!this.rqueueLockManager.acquireLock(lockKey, lockValue, lockDuration)) {
                TimeoutUtils.sleep(sleepDuration);
                continue;
            }
            MessageMetadata localMessageMetadata = this.getMessageMetadata();
            localMessageMetadata.merge(this.getLatestMessageMetadata());
            try {
                callable.call();
                return;
            }
            catch (Exception e) {
                log.error("Saving message metadata failed", (Throwable)e);
            }
            finally {
                this.rqueueLockManager.releaseLock(lockKey, lockValue);
            }
        }
        try {
            callable.call();
        }
        catch (Exception e) {
            log.error("Saving message metadata failed", (Throwable)e);
        }
    }

    void updateMessageStatus(MessageStatus messageStatus) {
        this.setMessageStatus(messageStatus);
        if (!messageStatus.isTerminalState() || this.getRqueueMessage().isPeriodic()) {
            Duration duration = this.rqueueConfig.getMessageDurability(this.getRqueueMessage().getPeriod());
            this.saveMessageMetadata(() -> {
                this.messageMetadataService.save(this.getMessageMetadata(), duration, false);
                return null;
            });
        } else {
            long ttl = this.rqueueConfig.getMessageDurabilityInMinute();
            if (ttl <= 0L || !this.rqueueConfig.messageInTerminalStateShouldBeStored()) {
                this.messageMetadataService.delete(this.rqueueJob.getMessageMetadata().getId());
            } else {
                this.saveMessageMetadata(() -> {
                    this.messageMetadataService.saveMessageMetadataForQueue(this.queueDetail.getCompletedQueueName(), this.getMessageMetadata(), this.rqueueConfig.messageDurabilityInTerminalStateInMillisecond());
                    return null;
                });
            }
        }
        this.save();
    }

    Execution execute() {
        Execution execution = this.rqueueJob.startNewExecution();
        this.save();
        return execution;
    }

    void updateExecutionStatus(ExecutionStatus status, Throwable e) {
        this.rqueueJob.updateExecutionStatus(status, e);
        this.save();
    }

    void updateExecutionTime(RqueueMessage rqueueMessage, MessageStatus messageStatus) {
        long executionTime = this.getExecutionTime();
        this.rqueueJob.getMessageMetadata().setRqueueMessage(rqueueMessage);
        if (this.getRqueueMessage().isPeriodic()) {
            this.rqueueJob.getMessageMetadata().setTotalExecutionTime(executionTime);
        } else {
            this.rqueueJob.getMessageMetadata().setTotalExecutionTime(executionTime + this.rqueueJob.getMessageMetadata().getTotalExecutionTime());
        }
        this.updateMessageStatus(messageStatus);
    }
}

