/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.sonus21.rqueue.models.Concurrency;
import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.db.DeadLetterQueue;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class QueueDetail
extends SerializableBase {
    private static final long serialVersionUID = 9153752084449974622L;
    private final long visibilityTimeout;
    private final String name;
    private final int numRetry;
    private final QueueType type;
    private final String queueName;
    private final String deadLetterQueueName;
    private final boolean deadLetterConsumerEnabled;
    private final String completedQueueName;
    private final String processingQueueName;
    private final String processingQueueChannelName;
    private final String scheduledQueueName;
    private final String scheduledQueueChannelName;
    private final boolean active;
    private final Concurrency concurrency;
    private final boolean systemGenerated;
    private final int batchSize;
    private Map<String, Integer> priority;
    private String priorityGroup;
    private Set<Class<? extends Throwable>> doNotRetry;

    public boolean isDlqSet() {
        return !StringUtils.isEmpty(this.deadLetterQueueName);
    }

    @JsonIgnore
    public DeadLetterQueue getDeadLetterQueue() {
        return new DeadLetterQueue(this.deadLetterQueueName, this.deadLetterConsumerEnabled);
    }

    public QueueConfig toConfig() {
        QueueConfig queueConfig = QueueConfig.builder().name(this.name).numRetry(this.numRetry).queueName(this.queueName).scheduledQueueName(this.scheduledQueueName).processingQueueName(this.processingQueueName).completedQueueName(this.completedQueueName).visibilityTimeout(this.visibilityTimeout).createdOn(System.currentTimeMillis()).updatedOn(System.currentTimeMillis()).deadLetterQueues(new LinkedList<DeadLetterQueue>()).concurrency(this.concurrency.toMinMax()).priority(Collections.unmodifiableMap(this.priority)).priorityGroup(this.priorityGroup).systemGenerated(this.systemGenerated).build();
        if (this.isDlqSet()) {
            queueConfig.addDeadLetterQueue(this.getDeadLetterQueue());
        }
        return queueConfig;
    }

    List<QueueDetail> expandQueueDetail(boolean addDefault, int priority) {
        ArrayList<QueueDetail> queueDetails = new ArrayList<QueueDetail>(1 + this.getPriority().size());
        for (Map.Entry<String, Integer> entry : this.getPriority().entrySet()) {
            QueueDetail cloneQueueDetail = this.cloneQueueDetail(entry.getKey(), entry.getValue(), this.name);
            queueDetails.add(cloneQueueDetail);
        }
        if (addDefault) {
            int defaultPriority = priority;
            if (defaultPriority == -1) {
                ArrayList<Integer> priorities = new ArrayList<Integer>(this.getPriority().values());
                priorities.sort(Comparator.comparingInt(o -> o));
                defaultPriority = (Integer)priorities.get(priorities.size() / 2);
            }
            HashMap<String, Integer> priorityMap = new HashMap<String, Integer>(this.priority);
            priorityMap.put("DEFAULT_PRIORITY", defaultPriority);
            this.priority = Collections.unmodifiableMap(priorityMap);
            this.priorityGroup = this.name;
            queueDetails.add(this);
        }
        return queueDetails;
    }

    private QueueDetail cloneQueueDetail(String priorityName, Integer priority, String priorityGroup) {
        if (priority == null || priorityName == null) {
            throw new IllegalStateException("priority name is null");
        }
        String suffix = PriorityUtils.getSuffix(priorityName);
        return QueueDetail.builder().numRetry(this.numRetry).visibilityTimeout(this.visibilityTimeout).deadLetterQueueName(this.deadLetterQueueName).deadLetterConsumerEnabled(this.deadLetterConsumerEnabled).name(this.name + suffix).queueName(this.queueName + suffix).processingQueueName(this.processingQueueName + suffix).processingQueueChannelName(this.processingQueueChannelName + suffix).scheduledQueueName(this.scheduledQueueName + suffix).scheduledQueueChannelName(this.scheduledQueueChannelName + suffix).completedQueueName(this.completedQueueName + suffix).active(this.active).batchSize(this.batchSize).systemGenerated(true).priorityGroup(priorityGroup).concurrency(this.concurrency).priority(Collections.singletonMap("DEFAULT_PRIORITY", priority)).doNotRetry(this.doNotRetry).build();
    }

    public Duration visibilityDuration() {
        return Duration.ofMillis(this.visibilityTimeout);
    }

    public boolean isDoNotRetryError(Throwable throwable) {
        if (Objects.isNull(throwable)) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.doNotRetry)) {
            return false;
        }
        if (this.doNotRetry.contains(throwable.getClass())) {
            return true;
        }
        Throwable t = throwable.getCause();
        return Objects.nonNull(t) && this.doNotRetry.contains(t.getClass());
    }

    @Generated
    private static QueueType $default$type() {
        return QueueType.QUEUE;
    }

    @Generated
    QueueDetail(long visibilityTimeout, String name, int numRetry, QueueType type, String queueName, String deadLetterQueueName, boolean deadLetterConsumerEnabled, String completedQueueName, String processingQueueName, String processingQueueChannelName, String scheduledQueueName, String scheduledQueueChannelName, boolean active, Concurrency concurrency, boolean systemGenerated, int batchSize, Map<String, Integer> priority, String priorityGroup, Set<Class<? extends Throwable>> doNotRetry) {
        this.visibilityTimeout = visibilityTimeout;
        this.name = name;
        this.numRetry = numRetry;
        this.type = type;
        this.queueName = queueName;
        this.deadLetterQueueName = deadLetterQueueName;
        this.deadLetterConsumerEnabled = deadLetterConsumerEnabled;
        this.completedQueueName = completedQueueName;
        this.processingQueueName = processingQueueName;
        this.processingQueueChannelName = processingQueueChannelName;
        this.scheduledQueueName = scheduledQueueName;
        this.scheduledQueueChannelName = scheduledQueueChannelName;
        this.active = active;
        this.concurrency = concurrency;
        this.systemGenerated = systemGenerated;
        this.batchSize = batchSize;
        this.priority = priority;
        this.priorityGroup = priorityGroup;
        this.doNotRetry = doNotRetry;
    }

    @Generated
    public static QueueDetailBuilder builder() {
        return new QueueDetailBuilder();
    }

    @Generated
    public long getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getNumRetry() {
        return this.numRetry;
    }

    @Generated
    public QueueType getType() {
        return this.type;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getDeadLetterQueueName() {
        return this.deadLetterQueueName;
    }

    @Generated
    public boolean isDeadLetterConsumerEnabled() {
        return this.deadLetterConsumerEnabled;
    }

    @Generated
    public String getCompletedQueueName() {
        return this.completedQueueName;
    }

    @Generated
    public String getProcessingQueueName() {
        return this.processingQueueName;
    }

    @Generated
    public String getProcessingQueueChannelName() {
        return this.processingQueueChannelName;
    }

    @Generated
    public String getScheduledQueueName() {
        return this.scheduledQueueName;
    }

    @Generated
    public String getScheduledQueueChannelName() {
        return this.scheduledQueueChannelName;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public boolean isSystemGenerated() {
        return this.systemGenerated;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public Map<String, Integer> getPriority() {
        return this.priority;
    }

    @Generated
    public String getPriorityGroup() {
        return this.priorityGroup;
    }

    @Generated
    public Set<Class<? extends Throwable>> getDoNotRetry() {
        return this.doNotRetry;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueDetail)) {
            return false;
        }
        QueueDetail other = (QueueDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVisibilityTimeout() != other.getVisibilityTimeout()) {
            return false;
        }
        if (this.getNumRetry() != other.getNumRetry()) {
            return false;
        }
        if (this.isDeadLetterConsumerEnabled() != other.isDeadLetterConsumerEnabled()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isSystemGenerated() != other.isSystemGenerated()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        QueueType this$type = this.getType();
        QueueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        String this$deadLetterQueueName = this.getDeadLetterQueueName();
        String other$deadLetterQueueName = other.getDeadLetterQueueName();
        if (this$deadLetterQueueName == null ? other$deadLetterQueueName != null : !this$deadLetterQueueName.equals(other$deadLetterQueueName)) {
            return false;
        }
        String this$completedQueueName = this.getCompletedQueueName();
        String other$completedQueueName = other.getCompletedQueueName();
        if (this$completedQueueName == null ? other$completedQueueName != null : !this$completedQueueName.equals(other$completedQueueName)) {
            return false;
        }
        String this$processingQueueName = this.getProcessingQueueName();
        String other$processingQueueName = other.getProcessingQueueName();
        if (this$processingQueueName == null ? other$processingQueueName != null : !this$processingQueueName.equals(other$processingQueueName)) {
            return false;
        }
        String this$processingQueueChannelName = this.getProcessingQueueChannelName();
        String other$processingQueueChannelName = other.getProcessingQueueChannelName();
        if (this$processingQueueChannelName == null ? other$processingQueueChannelName != null : !this$processingQueueChannelName.equals(other$processingQueueChannelName)) {
            return false;
        }
        String this$scheduledQueueName = this.getScheduledQueueName();
        String other$scheduledQueueName = other.getScheduledQueueName();
        if (this$scheduledQueueName == null ? other$scheduledQueueName != null : !this$scheduledQueueName.equals(other$scheduledQueueName)) {
            return false;
        }
        String this$scheduledQueueChannelName = this.getScheduledQueueChannelName();
        String other$scheduledQueueChannelName = other.getScheduledQueueChannelName();
        if (this$scheduledQueueChannelName == null ? other$scheduledQueueChannelName != null : !this$scheduledQueueChannelName.equals(other$scheduledQueueChannelName)) {
            return false;
        }
        Concurrency this$concurrency = this.getConcurrency();
        Concurrency other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
            return false;
        }
        Map<String, Integer> this$priority = this.getPriority();
        Map<String, Integer> other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$priorityGroup = this.getPriorityGroup();
        String other$priorityGroup = other.getPriorityGroup();
        if (this$priorityGroup == null ? other$priorityGroup != null : !this$priorityGroup.equals(other$priorityGroup)) {
            return false;
        }
        Set<Class<? extends Throwable>> this$doNotRetry = this.getDoNotRetry();
        Set<Class<? extends Throwable>> other$doNotRetry = other.getDoNotRetry();
        return !(this$doNotRetry == null ? other$doNotRetry != null : !((Object)this$doNotRetry).equals(other$doNotRetry));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueDetail;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $visibilityTimeout = this.getVisibilityTimeout();
        result = result * 59 + (int)($visibilityTimeout >>> 32 ^ $visibilityTimeout);
        result = result * 59 + this.getNumRetry();
        result = result * 59 + (this.isDeadLetterConsumerEnabled() ? 79 : 97);
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isSystemGenerated() ? 79 : 97);
        result = result * 59 + this.getBatchSize();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        QueueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        String $deadLetterQueueName = this.getDeadLetterQueueName();
        result = result * 59 + ($deadLetterQueueName == null ? 43 : $deadLetterQueueName.hashCode());
        String $completedQueueName = this.getCompletedQueueName();
        result = result * 59 + ($completedQueueName == null ? 43 : $completedQueueName.hashCode());
        String $processingQueueName = this.getProcessingQueueName();
        result = result * 59 + ($processingQueueName == null ? 43 : $processingQueueName.hashCode());
        String $processingQueueChannelName = this.getProcessingQueueChannelName();
        result = result * 59 + ($processingQueueChannelName == null ? 43 : $processingQueueChannelName.hashCode());
        String $scheduledQueueName = this.getScheduledQueueName();
        result = result * 59 + ($scheduledQueueName == null ? 43 : $scheduledQueueName.hashCode());
        String $scheduledQueueChannelName = this.getScheduledQueueChannelName();
        result = result * 59 + ($scheduledQueueChannelName == null ? 43 : $scheduledQueueChannelName.hashCode());
        Concurrency $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
        Map<String, Integer> $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $priorityGroup = this.getPriorityGroup();
        result = result * 59 + ($priorityGroup == null ? 43 : $priorityGroup.hashCode());
        Set<Class<? extends Throwable>> $doNotRetry = this.getDoNotRetry();
        result = result * 59 + ($doNotRetry == null ? 43 : ((Object)$doNotRetry).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueueDetail(visibilityTimeout=" + this.getVisibilityTimeout() + ", name=" + this.getName() + ", numRetry=" + this.getNumRetry() + ", type=" + String.valueOf((Object)this.getType()) + ", queueName=" + this.getQueueName() + ", deadLetterQueueName=" + this.getDeadLetterQueueName() + ", deadLetterConsumerEnabled=" + this.isDeadLetterConsumerEnabled() + ", completedQueueName=" + this.getCompletedQueueName() + ", processingQueueName=" + this.getProcessingQueueName() + ", processingQueueChannelName=" + this.getProcessingQueueChannelName() + ", scheduledQueueName=" + this.getScheduledQueueName() + ", scheduledQueueChannelName=" + this.getScheduledQueueChannelName() + ", active=" + this.isActive() + ", concurrency=" + String.valueOf(this.getConcurrency()) + ", systemGenerated=" + this.isSystemGenerated() + ", batchSize=" + this.getBatchSize() + ", priority=" + String.valueOf(this.getPriority()) + ", priorityGroup=" + this.getPriorityGroup() + ", doNotRetry=" + String.valueOf(this.getDoNotRetry()) + ")";
    }

    @Generated
    public static class QueueDetailBuilder {
        @Generated
        private long visibilityTimeout;
        @Generated
        private String name;
        @Generated
        private int numRetry;
        @Generated
        private boolean type$set;
        @Generated
        private QueueType type$value;
        @Generated
        private String queueName;
        @Generated
        private String deadLetterQueueName;
        @Generated
        private boolean deadLetterConsumerEnabled;
        @Generated
        private String completedQueueName;
        @Generated
        private String processingQueueName;
        @Generated
        private String processingQueueChannelName;
        @Generated
        private String scheduledQueueName;
        @Generated
        private String scheduledQueueChannelName;
        @Generated
        private boolean active;
        @Generated
        private Concurrency concurrency;
        @Generated
        private boolean systemGenerated;
        @Generated
        private int batchSize;
        @Generated
        private Map<String, Integer> priority;
        @Generated
        private String priorityGroup;
        @Generated
        private Set<Class<? extends Throwable>> doNotRetry;

        @Generated
        QueueDetailBuilder() {
        }

        @Generated
        public QueueDetailBuilder visibilityTimeout(long visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        @Generated
        public QueueDetailBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public QueueDetailBuilder numRetry(int numRetry) {
            this.numRetry = numRetry;
            return this;
        }

        @Generated
        public QueueDetailBuilder type(QueueType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public QueueDetailBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder deadLetterQueueName(String deadLetterQueueName) {
            this.deadLetterQueueName = deadLetterQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder deadLetterConsumerEnabled(boolean deadLetterConsumerEnabled) {
            this.deadLetterConsumerEnabled = deadLetterConsumerEnabled;
            return this;
        }

        @Generated
        public QueueDetailBuilder completedQueueName(String completedQueueName) {
            this.completedQueueName = completedQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder processingQueueName(String processingQueueName) {
            this.processingQueueName = processingQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder processingQueueChannelName(String processingQueueChannelName) {
            this.processingQueueChannelName = processingQueueChannelName;
            return this;
        }

        @Generated
        public QueueDetailBuilder scheduledQueueName(String scheduledQueueName) {
            this.scheduledQueueName = scheduledQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder scheduledQueueChannelName(String scheduledQueueChannelName) {
            this.scheduledQueueChannelName = scheduledQueueChannelName;
            return this;
        }

        @Generated
        public QueueDetailBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public QueueDetailBuilder concurrency(Concurrency concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @Generated
        public QueueDetailBuilder systemGenerated(boolean systemGenerated) {
            this.systemGenerated = systemGenerated;
            return this;
        }

        @Generated
        public QueueDetailBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Generated
        public QueueDetailBuilder priority(Map<String, Integer> priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public QueueDetailBuilder priorityGroup(String priorityGroup) {
            this.priorityGroup = priorityGroup;
            return this;
        }

        @Generated
        public QueueDetailBuilder doNotRetry(Set<Class<? extends Throwable>> doNotRetry) {
            this.doNotRetry = doNotRetry;
            return this;
        }

        @Generated
        public QueueDetail build() {
            QueueType type$value = this.type$value;
            if (!this.type$set) {
                type$value = QueueDetail.$default$type();
            }
            return new QueueDetail(this.visibilityTimeout, this.name, this.numRetry, type$value, this.queueName, this.deadLetterQueueName, this.deadLetterConsumerEnabled, this.completedQueueName, this.processingQueueName, this.processingQueueChannelName, this.scheduledQueueName, this.scheduledQueueChannelName, this.active, this.concurrency, this.systemGenerated, this.batchSize, this.priority, this.priorityGroup, this.doNotRetry);
        }

        @Generated
        public String toString() {
            return "QueueDetail.QueueDetailBuilder(visibilityTimeout=" + this.visibilityTimeout + ", name=" + this.name + ", numRetry=" + this.numRetry + ", type$value=" + String.valueOf((Object)this.type$value) + ", queueName=" + this.queueName + ", deadLetterQueueName=" + this.deadLetterQueueName + ", deadLetterConsumerEnabled=" + this.deadLetterConsumerEnabled + ", completedQueueName=" + this.completedQueueName + ", processingQueueName=" + this.processingQueueName + ", processingQueueChannelName=" + this.processingQueueChannelName + ", scheduledQueueName=" + this.scheduledQueueName + ", scheduledQueueChannelName=" + this.scheduledQueueChannelName + ", active=" + this.active + ", concurrency=" + String.valueOf(this.concurrency) + ", systemGenerated=" + this.systemGenerated + ", batchSize=" + this.batchSize + ", priority=" + String.valueOf(this.priority) + ", priorityGroup=" + this.priorityGroup + ", doNotRetry=" + String.valueOf(this.doNotRetry) + ")";
        }
    }

    public static enum QueueType {
        QUEUE,
        STREAM;

    }
}

