/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.metrics;

import com.github.sonus21.rqueue.config.MetricsProperties;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.metrics.QueueCounter;
import com.github.sonus21.rqueue.metrics.RqueueMetricsRegistry;
import com.github.sonus21.rqueue.models.event.RqueueBootstrapEvent;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;

public class RqueueMetrics
implements RqueueMetricsRegistry {
    static final String QUEUE_KEY = "key";
    private static final String QUEUE_SIZE = "queue.size";
    private static final String SCHEDULED_QUEUE_SIZE = "scheduled.queue.size";
    private static final String PROCESSING_QUEUE_SIZE = "processing.queue.size";
    private static final String DEAD_LETTER_QUEUE_SIZE = "dead.letter.queue.size";
    private final QueueCounter queueCounter;
    @Autowired
    private MetricsProperties metricsProperties;
    @Autowired
    private MeterRegistry meterRegistry;
    @Autowired
    private RqueueStringDao rqueueStringDao;

    public RqueueMetrics(QueueCounter queueCounter) {
        this.queueCounter = queueCounter;
    }

    private long size(String name, boolean isZset) {
        Long val = !isZset ? this.rqueueStringDao.getListSize(name) : this.rqueueStringDao.getSortedSetSize(name);
        if (val == null) {
            return 0L;
        }
        return val;
    }

    private void monitor() {
        for (QueueDetail queueDetail : EndpointRegistry.getActiveQueueDetails()) {
            Tags queueTags = Tags.concat((Iterable)this.metricsProperties.getMetricTags(), (String[])new String[]{"queue", queueDetail.getName()});
            Gauge.builder((String)QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getQueueName(), false)).tags((Iterable)queueTags.and(QUEUE_KEY, queueDetail.getQueueName())).description("The number of entries in this queue").register(this.meterRegistry);
            Gauge.builder((String)PROCESSING_QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getProcessingQueueName(), true)).tags((Iterable)queueTags.and(QUEUE_KEY, queueDetail.getProcessingQueueName())).description("The number of entries in the processing queue").register(this.meterRegistry);
            Gauge.builder((String)SCHEDULED_QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getScheduledQueueName(), true)).tags((Iterable)queueTags.and(QUEUE_KEY, queueDetail.getScheduledQueueName())).description("The number of entries waiting in the scheduled queue").register(this.meterRegistry);
            if (queueDetail.isDlqSet()) {
                Gauge.Builder builder = Gauge.builder((String)DEAD_LETTER_QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getDeadLetterQueueName(), false));
                builder.tags((Iterable)queueTags);
                builder.description("The number of entries in the dead letter queue");
                builder.register(this.meterRegistry);
            }
            this.queueCounter.registerQueue(this.metricsProperties, queueTags, this.meterRegistry, queueDetail);
        }
    }

    @Async
    public void onApplicationEvent(RqueueBootstrapEvent event) {
        if (event.isStartup()) {
            this.monitor();
        }
    }

    @Override
    public QueueCounter getQueueCounter() {
        return this.queueCounter;
    }
}

