/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.utils.PrefixLogger;
import java.util.Iterator;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class RetryableRunnable<V>
extends PrefixLogger
implements Runnable {
    private Iterator<V> generator;

    protected RetryableRunnable(Logger log, String groupName) {
        super(log, groupName);
    }

    protected RetryableRunnable(Logger log, String groupName, Iterator<V> generator) {
        super(log, groupName);
        this.generator = generator;
    }

    public void consume(V v) {
        throw new NotImplementedException("method is not implemented");
    }

    public void start() {
        throw new NotImplementedException("method is not implemented");
    }

    @Override
    public void run() {
        if (this.generator == null) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.log(Level.ERROR, "Failed {}", e, e.getMessage());
            }
        } else {
            while (this.generator.hasNext()) {
                V v = this.generator.next();
                try {
                    this.consume(v);
                }
                catch (Exception e) {
                    this.log(Level.ERROR, "Failed {} V: {}", e, e.getMessage(), v);
                }
            }
        }
    }
}

