/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.utils.StringUtils;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.NonNull;

public final class ValueResolver {
    private ValueResolver() {
    }

    public static <T> T parseStringUsingSpel(String val, Class<?> t) {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(val);
        return (T)exp.getValue(t);
    }

    public static Long parseStringToLong(String val) {
        if (val == null) {
            return null;
        }
        String tmpVal = StringUtils.clean(val);
        if (tmpVal.equals("null")) {
            return null;
        }
        return (Long)ValueResolver.parseStringUsingSpel(val, Long.class);
    }

    public static Integer parseStringToInt(String val) {
        if (val == null) {
            return null;
        }
        String tmpVal = StringUtils.clean(val);
        if (tmpVal.equals("null") || tmpVal.isEmpty()) {
            return null;
        }
        return (Integer)ValueResolver.parseStringUsingSpel(val, Integer.class);
    }

    public static boolean convertToBoolean(String s) {
        String tmpString = StringUtils.clean(s);
        if (tmpString == null) {
            return false;
        }
        if (tmpString.equalsIgnoreCase("true") || tmpString.equals("1") || tmpString.equalsIgnoreCase("yes")) {
            return true;
        }
        if (tmpString.equalsIgnoreCase("false") || tmpString.equals("0") || tmpString.equals("") || tmpString.equalsIgnoreCase("no")) {
            return false;
        }
        throw new IllegalArgumentException(s + " cannot be converted to boolean");
    }

    @NonNull
    private static Object resolveExpression(ApplicationContext applicationContext, String name) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableListableBeanFactory configurableBeanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
            String placeholdersResolved = configurableBeanFactory.resolveEmbeddedValue(name);
            BeanExpressionResolver exprResolver = configurableBeanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return name;
            }
            Object result = exprResolver.evaluate(placeholdersResolved, new BeanExpressionContext((ConfigurableBeanFactory)configurableBeanFactory, null));
            if (result != null) {
                return result;
            }
        }
        return name;
    }

    public static String[] resolveKeyToArrayOfStrings(ApplicationContext applicationContext, String name) {
        Object result = ValueResolver.resolveExpression(applicationContext, name);
        String[] values = result instanceof String[] ? (String[])result : ((String)result).split(",");
        String[] cleanedStrings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            cleanedStrings[i] = StringUtils.clean(values[i]);
        }
        return cleanedStrings;
    }

    public static String resolveKeyToString(ApplicationContext applicationContext, String name) {
        String[] values = ValueResolver.resolveKeyToArrayOfStrings(applicationContext, name);
        if (values.length == 1) {
            return values[0];
        }
        throw new IllegalArgumentException("More than one value provided");
    }

    public static Integer resolveKeyToInteger(ApplicationContext applicationContext, String name) {
        Object result = ValueResolver.resolveExpression(applicationContext, name);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        return ValueResolver.parseStringToInt((String)result);
    }

    public static Long resolveKeyToLong(ApplicationContext applicationContext, String name) {
        Object result = ValueResolver.resolveExpression(applicationContext, name);
        if (result instanceof Long) {
            return (Long)result;
        }
        if (result instanceof Integer) {
            return ((Integer)result).longValue();
        }
        return ValueResolver.parseStringToLong((String)result);
    }

    public static boolean resolveToBoolean(ApplicationContext applicationContext, String name) {
        Object result = ValueResolver.resolveExpression(applicationContext, name);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return ValueResolver.convertToBoolean((String)result);
    }
}

