/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils.pebble;

import io.pebbletemplates.pebble.error.LoaderException;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.utils.PathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ResourceLoader
implements Loader<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);
    private String prefix;
    private String suffix;
    private String charset = "UTF-8";

    public Reader getReader(String templateName) {
        String location = this.getLocation(templateName);
        log.debug("Looking for template in {}.", (Object)location);
        ClassPathResource resource = new ClassPathResource(location);
        try {
            InputStream is = resource.getInputStream();
            try {
                return new BufferedReader(new InputStreamReader(is, this.charset));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        }
        catch (IOException e) {
            throw new LoaderException(null, "Could not find template \"" + location + "\"");
        }
        return null;
    }

    private String getLocation(String templateName) {
        return this.getPrefix() + templateName + this.getSuffix();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String resolveRelativePath(String relativePath, String anchorPath) {
        return PathUtils.resolveRelativePath((String)relativePath, (String)anchorPath, (char)'/');
    }

    public String createCacheKey(String templateName) {
        return templateName;
    }

    public boolean resourceExists(String templateName) {
        return new ClassPathResource(this.getLocation(templateName)).exists();
    }
}

