/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.controller;

import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.exception.ProcessingException;
import com.github.sonus21.rqueue.models.enums.AggregationType;
import com.github.sonus21.rqueue.models.request.ChartDataRequest;
import com.github.sonus21.rqueue.models.request.DataDeleteRequest;
import com.github.sonus21.rqueue.models.request.DataTypeRequest;
import com.github.sonus21.rqueue.models.request.DateViewRequest;
import com.github.sonus21.rqueue.models.request.MessageDeleteRequest;
import com.github.sonus21.rqueue.models.request.MessageMoveRequest;
import com.github.sonus21.rqueue.models.request.PauseUnpauseQueueRequest;
import com.github.sonus21.rqueue.models.request.QueueExploreRequest;
import com.github.sonus21.rqueue.models.response.BaseResponse;
import com.github.sonus21.rqueue.models.response.BooleanResponse;
import com.github.sonus21.rqueue.models.response.ChartDataResponse;
import com.github.sonus21.rqueue.models.response.DataSelectorResponse;
import com.github.sonus21.rqueue.models.response.DataViewResponse;
import com.github.sonus21.rqueue.models.response.MessageMoveResponse;
import com.github.sonus21.rqueue.models.response.StringResponse;
import com.github.sonus21.rqueue.utils.condition.ReactiveDisabled;
import com.github.sonus21.rqueue.web.controller.BaseController;
import com.github.sonus21.rqueue.web.service.RqueueDashboardChartService;
import com.github.sonus21.rqueue.web.service.RqueueJobService;
import com.github.sonus21.rqueue.web.service.RqueueQDetailService;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import com.github.sonus21.rqueue.web.service.RqueueUtilityService;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${rqueue.web.url.prefix:}rqueue/api/v1"})
@Conditional(value={ReactiveDisabled.class})
public class RqueueRestController
extends BaseController {
    private final RqueueDashboardChartService rqueueDashboardChartService;
    private final RqueueQDetailService rqueueQDetailService;
    private final RqueueUtilityService rqueueUtilityService;
    private final RqueueSystemManagerService rqueueQManagerService;
    private final RqueueJobService rqueueJobService;

    @Autowired
    public RqueueRestController(RqueueDashboardChartService rqueueDashboardChartService, RqueueQDetailService rqueueQDetailService, RqueueUtilityService rqueueUtilityService, RqueueSystemManagerService rqueueQManagerService, RqueueWebConfig rqueueWebConfig, RqueueJobService rqueueJobService) {
        super(rqueueWebConfig);
        this.rqueueDashboardChartService = rqueueDashboardChartService;
        this.rqueueQDetailService = rqueueQDetailService;
        this.rqueueUtilityService = rqueueUtilityService;
        this.rqueueQManagerService = rqueueQManagerService;
        this.rqueueJobService = rqueueJobService;
    }

    @PostMapping(value={"chart"})
    @ResponseBody
    public ChartDataResponse getDashboardData(@RequestBody @Valid ChartDataRequest chartDataRequest, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueDashboardChartService.getDashboardChartData(chartDataRequest);
        }
        return null;
    }

    @GetMapping(value={"jobs"})
    @ResponseBody
    public DataViewResponse getJobs(@RequestParam(name="message-id") @NotEmpty String messageId, HttpServletResponse response) throws ProcessingException {
        if (this.isEnable(response)) {
            return this.rqueueJobService.getJobs(messageId);
        }
        return null;
    }

    @PostMapping(value={"queue-data"})
    @ResponseBody
    public DataViewResponse exploreQueue(@Valid @RequestBody QueueExploreRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueQDetailService.getExplorePageData(request.getSrc(), request.getName(), request.getType(), request.getPageNumber(), request.getItemPerPage());
        }
        return null;
    }

    @PostMapping(value={"view-data"})
    @ResponseBody
    public DataViewResponse viewData(@RequestBody @Valid DateViewRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueQDetailService.viewData(request.getName(), request.getType(), request.getKey(), request.getPageNumber(), request.getItemPerPage());
        }
        return null;
    }

    @PostMapping(value={"delete-message"})
    @ResponseBody
    public BooleanResponse deleteMessage(@Valid @RequestBody MessageDeleteRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueUtilityService.deleteMessage(request.getQueueName(), request.getMessageId());
        }
        return null;
    }

    @PostMapping(value={"delete-queue"})
    @ResponseBody
    public BaseResponse deleteQueue(@Valid @RequestBody DataTypeRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueQManagerService.deleteQueue(request.getName());
        }
        return null;
    }

    @PostMapping(value={"delete-queue-part"})
    @ResponseBody
    public BooleanResponse deleteAll(@RequestBody @Valid DataDeleteRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueUtilityService.makeEmpty(request.getQueueName(), request.getDatasetName());
        }
        return null;
    }

    @PostMapping(value={"data-type"})
    @ResponseBody
    public StringResponse dataType(@RequestBody @Valid DataTypeRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueUtilityService.getDataType(request.getName());
        }
        return null;
    }

    @PostMapping(value={"move-data"})
    @ResponseBody
    public MessageMoveResponse dataType(@RequestBody @Valid MessageMoveRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueUtilityService.moveMessage(request);
        }
        return null;
    }

    @PostMapping(value={"pause-unpause-queue"})
    @ResponseBody
    public BaseResponse pauseUnpauseQueue(@RequestBody @Valid PauseUnpauseQueueRequest request, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueUtilityService.pauseUnpauseQueue(request);
        }
        return null;
    }

    @GetMapping(value={"aggregate-data-selector"})
    @ResponseBody
    public DataSelectorResponse aggregateDataCounter(@RequestParam AggregationType type, HttpServletResponse response) {
        if (this.isEnable(response)) {
            return this.rqueueUtilityService.aggregateDataCounter(type);
        }
        return null;
    }
}

