/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.spotbugs;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.xml.XmlParser;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codehaus.mojo.spotbugs.SpotBugsInfo;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;

public abstract class BaseViolationCheckMojo
extends AbstractMojo
implements GroovyObject {
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false", property="spotbugs.xmlOutput", required=true)
    private boolean xmlOutput;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File xmlOutputDirectory;
    @Deprecated
    @Parameter(defaultValue="true")
    private boolean spotbugsXmlOutput;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File spotbugsXmlOutputDirectory;
    @Parameter(defaultValue="spotbugsXml.xml", property="spotbugs.outputXmlFilename")
    private String spotbugsXmlOutputFilename;
    @Component(role=Renderer.class)
    private Renderer siteRenderer;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classFilesDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private File testClassFilesDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref")
    private File xrefLocation;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref-test")
    private File xrefTestLocation;
    @Parameter(readonly=true, defaultValue="${project.compileSourceRoots}", required=true)
    private List compileSourceRoots;
    @Parameter(readonly=true, defaultValue="${project.testCompileSourceRoots}", required=true)
    private List testSourceRoots;
    @Parameter(defaultValue="false", property="spotbugs.includeTests")
    private boolean includeTests;
    @Parameter(readonly=true, property="plugin.artifacts", required=true)
    private List pluginArtifacts;
    @Parameter(readonly=true, property="localRepository", required=true)
    private ArtifactRepository localRepository;
    @Parameter(readonly=true, property="project.remoteArtifactRepositories", required=true)
    private List remoteArtifactRepositories;
    @Parameter(readonly=true, defaultValue="${session}", required=true)
    private MavenSession session;
    @Parameter(readonly=true, property="project", required=true)
    private MavenProject project;
    @Parameter(readonly=true, defaultValue="UTF-8")
    private String xmlEncoding;
    @Parameter(defaultValue="${project.build.sourceEncoding}", property="encoding")
    private String sourceEncoding;
    @Parameter(defaultValue="${project.reporting.outputEncoding}", property="outputEncoding")
    private String outputEncoding;
    @Parameter(defaultValue="Default", property="spotbugs.threshold")
    private String threshold;
    @Component(role=ArtifactResolver.class)
    private ArtifactResolver artifactResolver;
    @Parameter(property="spotbugs.includeFilterFile")
    private String includeFilterFile;
    @Parameter(property="spotbugs.excludeFilterFile")
    private String excludeFilterFile;
    @Parameter(property="spotbugs.excludeBugsFile")
    private String excludeBugsFile;
    @Parameter(defaultValue="Default", property="spotbugs.effort")
    private String effort;
    @Parameter(defaultValue="false", property="spotbugs.debug")
    private Boolean debug;
    @Parameter(defaultValue="false", property="spotbugs.relaxed")
    private Boolean relaxed;
    @Parameter(property="spotbugs.visitors")
    private String visitors;
    @Parameter(property="spotbugs.omitVisitors")
    private String omitVisitors;
    @Parameter(property="spotbugs.pluginList")
    private String pluginList;
    @Parameter(property="spotbugs.onlyAnalyze")
    private String onlyAnalyze;
    @Parameter(defaultValue="false", property="spotbugs.nested")
    private Boolean nested;
    @Parameter(defaultValue="false", property="spotbugs.trace")
    private Boolean trace;
    @Parameter(property="spotbugs.maxRank")
    private int maxRank;
    @Parameter(defaultValue="false", property="spotbugs.skip")
    private boolean skip;
    @Component(role=ResourceManager.class)
    private ResourceManager resourceManager;
    @Component(role=SiteTool.class)
    private SiteTool siteTool;
    @Parameter(defaultValue="true", property="spotbugs.failOnError")
    private boolean failOnError;
    @Parameter(property="spotbugs.failThreshold")
    private String failThreshold;
    @Parameter(defaultValue="true", property="spotbugs.fork")
    private boolean fork;
    @Parameter(defaultValue="512", property="spotbugs.maxHeap")
    private int maxHeap;
    @Parameter(defaultValue="600000", property="spotbugs.timeout")
    private int timeout;
    @Parameter(property="spotbugs.jvmArgs")
    private String jvmArgs;
    @Parameter(defaultValue="0", property="spotbugs.maxAllowedViolations")
    private int maxAllowedViolations;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public BaseViolationCheckMojo() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void execute() {
        CallSite locale = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getDefault", 0, Locale.class));
        CallSite sourceFiles = null;
        IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Executing spotbugs:check");
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "exists", 0, this.classFilesDirectory)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isDirectory", 0, this.classFilesDirectory))) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "getFiles", 0, FileUtils.class, this.classFilesDirectory, IndyInterface.bootstrap("getProperty", "JAVA_REGEX_PATTERN", 0, SpotBugsInfo.class), null);
            sourceFiles = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        if (!this.skip && DefaultTypeTransformation.booleanUnbox(sourceFiles)) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Here goes...............Executing spotbugs:check");
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, this.spotbugsXmlOutputDirectory)) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdirs", 0, this.spotbugsXmlOutputDirectory)) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, "Cannot create xml output directory"));
            }
            CallSite outputFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.spotbugsXmlOutputDirectory, this.spotbugsXmlOutputFilename}, new String[]{"", "/", ""})));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, outputFile)) != false) {
                CallSite xml = IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlParser.class), outputFile);
                CallSite bugs = IndyInterface.bootstrap("getProperty", "BugInstance", 0, xml);
                CallSite bugCount = IndyInterface.bootstrap("invoke", "size", 0, bugs);
                IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{bugCount}, new String[]{"BugInstance size is ", ""}));
                CallSite errorCount = IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "Error", 0, xml));
                IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{errorCount}, new String[]{"Error size is ", ""}));
                if (ScriptBytecodeAdapter.compareLessThanEqual((Object)bugCount, (Object)0)) {
                    IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "No errors/warnings found");
                    return;
                }
                if (this.maxAllowedViolations > 0 && ScriptBytecodeAdapter.compareLessThanEqual((Object)bugCount, (Object)this.maxAllowedViolations)) {
                    IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{bugCount}, new String[]{"total ", " violations are found which is set to be acceptable using configured property maxAllowedViolations :"}), this.maxAllowedViolations), ".\nBelow are list of bugs ignored :\n"));
                    IndyInterface.bootstrap("invoke", "printBugs", 2, this, bugCount, bugs);
                    return;
                }
                IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "Total bugs: ", bugCount));
                Integer bugCountAboveThreshold = 0;
                CallSite priorityThresholdNum = IndyInterface.bootstrap("cast", "()", 0, this.failThreshold) != false ? IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "spotbugsPriority", 0, SpotBugsInfo.class), this.failThreshold) : IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class);
                if (ScriptBytecodeAdapter.compareEqual((Object)priorityThresholdNum, (Object)-1)) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, new GStringImpl(new Object[]{this.failThreshold}, new String[]{"Invalid value for failThreshold: ", ""})));
                }
                Object i = null;
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ScriptBytecodeAdapter.createRange((Object)0, (Object)IndyInterface.bootstrap("invoke", "minus", 0, bugCount, true), (boolean)false, (boolean)false)));
                while (callSite.hasNext()) {
                    i = callSite.next();
                    CallSite bug = IndyInterface.bootstrap("invoke", "getAt", 0, bugs, i);
                    Integer priorityNum = (int)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "@priority", 0, bug), Integer.class)));
                    CallSite priorityName = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "spotbugsPriority", 0, SpotBugsInfo.class), priorityNum);
                    CallSite logMsg = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, priorityName, ": "), IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "LongMessage", 0, bug))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@classname", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "Message", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug)))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@type", 0, bug));
                    if (ScriptBytecodeAdapter.compareLessThanEqual((Object)priorityNum, (Object)priorityThresholdNum)) {
                        IndyInterface.bootstrap("invoke", "plus", 0, bugCountAboveThreshold, true);
                        IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), logMsg);
                        continue;
                    }
                    IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), logMsg);
                }
                IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "\n\n\nTo see bug detail using the Spotbugs GUI, use the following command \"mvn spotbugs:gui\"\n\n\n");
                if ((DefaultTypeTransformation.booleanUnbox((Object)bugCountAboveThreshold) || DefaultTypeTransformation.booleanUnbox((Object)errorCount)) && this.failOnError) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, new GStringImpl(new Object[]{bugCountAboveThreshold, errorCount}, new String[]{"failed with ", " bugs and ", " errors "})));
                }
            }
        } else {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Nothing for SpotBugs to do here.");
        }
    }

    private void printBugs(Object total, Object bugs) {
        Object i = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ScriptBytecodeAdapter.createRange((Object)0, (Object)IndyInterface.bootstrap("invoke", "minus", 0, total, true), (boolean)false, (boolean)false)));
        while (callSite.hasNext()) {
            i = callSite.next();
            CallSite bug = IndyInterface.bootstrap("invoke", "getAt", 0, bugs, i);
            IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "LongMessage", 0, bug)), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@classname", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "Message", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug)))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@type", 0, bug)));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BaseViolationCheckMojo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public void setOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    @Generated
    public boolean getXmlOutput() {
        return this.xmlOutput;
    }

    @Generated
    public boolean isXmlOutput() {
        return this.xmlOutput;
    }

    @Generated
    public void setXmlOutput(boolean bl) {
        this.xmlOutput = bl;
    }

    @Generated
    public File getXmlOutputDirectory() {
        return this.xmlOutputDirectory;
    }

    @Generated
    public void setXmlOutputDirectory(File file) {
        this.xmlOutputDirectory = file;
    }

    @Generated
    public boolean getSpotbugsXmlOutput() {
        return this.spotbugsXmlOutput;
    }

    @Generated
    public boolean isSpotbugsXmlOutput() {
        return this.spotbugsXmlOutput;
    }

    @Generated
    public void setSpotbugsXmlOutput(boolean bl) {
        this.spotbugsXmlOutput = bl;
    }

    @Generated
    public File getSpotbugsXmlOutputDirectory() {
        return this.spotbugsXmlOutputDirectory;
    }

    @Generated
    public void setSpotbugsXmlOutputDirectory(File file) {
        this.spotbugsXmlOutputDirectory = file;
    }

    @Generated
    public String getSpotbugsXmlOutputFilename() {
        return this.spotbugsXmlOutputFilename;
    }

    @Generated
    public void setSpotbugsXmlOutputFilename(String string) {
        this.spotbugsXmlOutputFilename = string;
    }

    @Generated
    public Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    @Generated
    public void setSiteRenderer(Renderer renderer) {
        this.siteRenderer = renderer;
    }

    @Generated
    public File getClassFilesDirectory() {
        return this.classFilesDirectory;
    }

    @Generated
    public void setClassFilesDirectory(File file) {
        this.classFilesDirectory = file;
    }

    @Generated
    public File getTestClassFilesDirectory() {
        return this.testClassFilesDirectory;
    }

    @Generated
    public void setTestClassFilesDirectory(File file) {
        this.testClassFilesDirectory = file;
    }

    @Generated
    public File getXrefLocation() {
        return this.xrefLocation;
    }

    @Generated
    public void setXrefLocation(File file) {
        this.xrefLocation = file;
    }

    @Generated
    public File getXrefTestLocation() {
        return this.xrefTestLocation;
    }

    @Generated
    public void setXrefTestLocation(File file) {
        this.xrefTestLocation = file;
    }

    @Generated
    public List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    @Generated
    public void setCompileSourceRoots(List list) {
        this.compileSourceRoots = list;
    }

    @Generated
    public List getTestSourceRoots() {
        return this.testSourceRoots;
    }

    @Generated
    public void setTestSourceRoots(List list) {
        this.testSourceRoots = list;
    }

    @Generated
    public boolean getIncludeTests() {
        return this.includeTests;
    }

    @Generated
    public boolean isIncludeTests() {
        return this.includeTests;
    }

    @Generated
    public void setIncludeTests(boolean bl) {
        this.includeTests = bl;
    }

    @Generated
    public List getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    @Generated
    public void setPluginArtifacts(List list) {
        this.pluginArtifacts = list;
    }

    @Generated
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Generated
    public void setLocalRepository(ArtifactRepository artifactRepository) {
        this.localRepository = artifactRepository;
    }

    @Generated
    public List getRemoteArtifactRepositories() {
        return this.remoteArtifactRepositories;
    }

    @Generated
    public void setRemoteArtifactRepositories(List list) {
        this.remoteArtifactRepositories = list;
    }

    @Generated
    public MavenSession getSession() {
        return this.session;
    }

    @Generated
    public void setSession(MavenSession mavenSession) {
        this.session = mavenSession;
    }

    @Generated
    public MavenProject getProject() {
        return this.project;
    }

    @Generated
    public void setProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    @Generated
    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    @Generated
    public void setXmlEncoding(String string) {
        this.xmlEncoding = string;
    }

    @Generated
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Generated
    public void setSourceEncoding(String string) {
        this.sourceEncoding = string;
    }

    @Generated
    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    @Generated
    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    @Generated
    public String getThreshold() {
        return this.threshold;
    }

    @Generated
    public void setThreshold(String string) {
        this.threshold = string;
    }

    @Generated
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    @Generated
    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    @Generated
    public String getIncludeFilterFile() {
        return this.includeFilterFile;
    }

    @Generated
    public void setIncludeFilterFile(String string) {
        this.includeFilterFile = string;
    }

    @Generated
    public String getExcludeFilterFile() {
        return this.excludeFilterFile;
    }

    @Generated
    public void setExcludeFilterFile(String string) {
        this.excludeFilterFile = string;
    }

    @Generated
    public String getExcludeBugsFile() {
        return this.excludeBugsFile;
    }

    @Generated
    public void setExcludeBugsFile(String string) {
        this.excludeBugsFile = string;
    }

    @Generated
    public String getEffort() {
        return this.effort;
    }

    @Generated
    public void setEffort(String string) {
        this.effort = string;
    }

    @Generated
    public Boolean getDebug() {
        return this.debug;
    }

    @Generated
    public void setDebug(Boolean bl) {
        this.debug = bl;
    }

    @Generated
    public Boolean getRelaxed() {
        return this.relaxed;
    }

    @Generated
    public void setRelaxed(Boolean bl) {
        this.relaxed = bl;
    }

    @Generated
    public String getVisitors() {
        return this.visitors;
    }

    @Generated
    public void setVisitors(String string) {
        this.visitors = string;
    }

    @Generated
    public String getOmitVisitors() {
        return this.omitVisitors;
    }

    @Generated
    public void setOmitVisitors(String string) {
        this.omitVisitors = string;
    }

    @Generated
    public String getPluginList() {
        return this.pluginList;
    }

    @Generated
    public void setPluginList(String string) {
        this.pluginList = string;
    }

    @Generated
    public String getOnlyAnalyze() {
        return this.onlyAnalyze;
    }

    @Generated
    public void setOnlyAnalyze(String string) {
        this.onlyAnalyze = string;
    }

    @Generated
    public Boolean getNested() {
        return this.nested;
    }

    @Generated
    public void setNested(Boolean bl) {
        this.nested = bl;
    }

    @Generated
    public Boolean getTrace() {
        return this.trace;
    }

    @Generated
    public void setTrace(Boolean bl) {
        this.trace = bl;
    }

    @Generated
    public int getMaxRank() {
        return this.maxRank;
    }

    @Generated
    public void setMaxRank(int n) {
        this.maxRank = n;
    }

    @Generated
    public boolean getSkip() {
        return this.skip;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public void setSkip(boolean bl) {
        this.skip = bl;
    }

    @Generated
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Generated
    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Generated
    public SiteTool getSiteTool() {
        return this.siteTool;
    }

    @Generated
    public void setSiteTool(SiteTool siteTool) {
        this.siteTool = siteTool;
    }

    @Generated
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    @Generated
    public String getFailThreshold() {
        return this.failThreshold;
    }

    @Generated
    public void setFailThreshold(String string) {
        this.failThreshold = string;
    }

    @Generated
    public boolean getFork() {
        return this.fork;
    }

    @Generated
    public boolean isFork() {
        return this.fork;
    }

    @Generated
    public void setFork(boolean bl) {
        this.fork = bl;
    }

    @Generated
    public int getMaxHeap() {
        return this.maxHeap;
    }

    @Generated
    public void setMaxHeap(int n) {
        this.maxHeap = n;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setTimeout(int n) {
        this.timeout = n;
    }

    @Generated
    public String getJvmArgs() {
        return this.jvmArgs;
    }

    @Generated
    public void setJvmArgs(String string) {
        this.jvmArgs = string;
    }

    @Generated
    public int getMaxAllowedViolations() {
        return this.maxAllowedViolations;
    }

    @Generated
    public void setMaxAllowedViolations(int n) {
        this.maxAllowedViolations = n;
    }
}

