/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.drive.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.social.google.api.drive.CommentReply;
import org.springframework.social.google.api.drive.DriveAbout;
import org.springframework.social.google.api.drive.DriveApp;
import org.springframework.social.google.api.drive.DriveFile;
import org.springframework.social.google.api.drive.DriveFileParent;
import org.springframework.social.google.api.drive.DriveFileQueryBuilder;
import org.springframework.social.google.api.drive.DriveFilesPage;
import org.springframework.social.google.api.drive.DriveOperations;
import org.springframework.social.google.api.drive.FileComment;
import org.springframework.social.google.api.drive.FileCommentQueryBuilder;
import org.springframework.social.google.api.drive.FileCommentsPage;
import org.springframework.social.google.api.drive.FileProperty;
import org.springframework.social.google.api.drive.FileRevision;
import org.springframework.social.google.api.drive.UploadParameters;
import org.springframework.social.google.api.drive.UserPermission;
import org.springframework.social.google.api.drive.impl.DriveAppsList;
import org.springframework.social.google.api.drive.impl.DriveFileQueryBuilderImpl;
import org.springframework.social.google.api.drive.impl.FileCommentQueryBuilderImpl;
import org.springframework.social.google.api.drive.impl.FilePropertiesList;
import org.springframework.social.google.api.drive.impl.FileRevisionsList;
import org.springframework.social.google.api.drive.impl.UserPermissionsList;
import org.springframework.social.google.api.impl.AbstractGoogleApiOperations;
import org.springframework.social.google.api.impl.PatchBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class DriveTemplate
extends AbstractGoogleApiOperations
implements DriveOperations {
    private static final String DRIVE_BASE_URL = "https://www.googleapis.com/drive/v2";
    static final String DRIVE_FILES_URL = "https://www.googleapis.com/drive/v2/files/";
    private static final String DRIVE_ABOUT_URL = "https://www.googleapis.com/drive/v2/about";
    private static final String DRIVE_APPS_URL = "https://www.googleapis.com/drive/v2/apps/";
    private static final String PERMISSIONS = "/permissions/";
    private static final String REVISIONS = "/revisions/";
    private static final String COMMENTS = "/comments/";
    private static final String REPLIES = "/replies/";
    private static final String PROPERTIES = "/properties/";
    private static final String SEND_NOTIFICATION = "?sendNotificationEmails=";
    private static final String MULTIPART_UPLOAD_URL = "https://www.googleapis.com/upload/drive/v2/files?uploadType=multipart";

    public DriveTemplate(RestTemplate restTemplate, boolean isAuthorized) {
        super(restTemplate, isAuthorized);
    }

    @Override
    public DriveAbout getAbout() {
        return this.getEntity(DRIVE_ABOUT_URL, DriveAbout.class);
    }

    @Override
    public List<DriveApp> getApps() {
        return this.getEntity(DRIVE_APPS_URL, DriveAppsList.class).getItems();
    }

    @Override
    public DriveApp getApp(String id) {
        return this.getEntity(DRIVE_APPS_URL + id, DriveApp.class);
    }

    @Override
    public DriveFile getFile(String id) {
        return this.getEntity(DRIVE_FILES_URL + id, DriveFile.class);
    }

    @Override
    public DriveFileQueryBuilder driveFileQuery() {
        return new DriveFileQueryBuilderImpl(this.restTemplate);
    }

    @Override
    public DriveFilesPage getRootFiles(String pageToken) {
        return this.getFiles("root", pageToken);
    }

    @Override
    public DriveFilesPage getFiles(String parent, String pageToken) {
        return (DriveFilesPage)((DriveFileQueryBuilder)this.driveFileQuery().parentIs(parent).fromPage(pageToken)).trashed(false).hidden(false).getPage();
    }

    @Override
    public DriveFilesPage getTrashedFiles(String pageToken) {
        return (DriveFilesPage)this.driveFileQuery().trashed(true).getPage();
    }

    @Override
    public DriveFile trash(String id) {
        return (DriveFile)this.restTemplate.postForObject(DRIVE_FILES_URL + id + "/trash", null, DriveFile.class, new Object[0]);
    }

    @Override
    public DriveFile untrash(String id) {
        return (DriveFile)this.restTemplate.postForObject(DRIVE_FILES_URL + id + "/untrash", null, DriveFile.class, new Object[0]);
    }

    @Override
    public DriveFile star(String id) {
        return this.patch(DRIVE_FILES_URL + id, new PatchBuilder().set("labels.starred", true).getMap(), DriveFile.class);
    }

    @Override
    public DriveFile unstar(String id) {
        return this.patch(DRIVE_FILES_URL + id, new PatchBuilder().set("labels.starred", false).getMap(), DriveFile.class);
    }

    @Override
    public DriveFile hide(String id) {
        return this.patch(DRIVE_FILES_URL + id, new PatchBuilder().set("labels.hidden", true).getMap(), DriveFile.class);
    }

    @Override
    public DriveFile unhide(String id) {
        return this.patch(DRIVE_FILES_URL + id, new PatchBuilder().set("labels.hidden", false).getMap(), DriveFile.class);
    }

    @Override
    public void delete(String id) {
        this.restTemplate.delete(DRIVE_FILES_URL + id, new Object[0]);
    }

    @Override
    public DriveFile copy(String id) {
        return (DriveFile)this.restTemplate.postForObject(DRIVE_FILES_URL + id + "/copy", null, DriveFile.class, new Object[0]);
    }

    @Override
    public DriveFile copy(String id, String[] parentIds) {
        DriveFile file = new DriveFile.Builder().setParents(parentIds).build();
        return this.saveEntity(DRIVE_FILES_URL + id + "/copy", file);
    }

    @Override
    public DriveFile copy(String id, String[] parentIds, String title) {
        DriveFile file = new DriveFile.Builder().setTitle(title).setParents(parentIds).build();
        return this.saveEntity(DRIVE_FILES_URL + id + "/copy", file);
    }

    @Override
    public DriveFile move(String id, String parentId) {
        ArrayList<DriveFileParent> parents = new ArrayList<DriveFileParent>(1);
        parents.add(new DriveFileParent(parentId));
        return this.patch(DRIVE_FILES_URL + id, new PatchBuilder().set("parents", parents).getMap(), DriveFile.class);
    }

    @Override
    public DriveFile upload(Resource resource, DriveFile metadata, UploadParameters parameters) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"metadata", (Object)metadata);
        body.add((Object)"file", (Object)resource);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(MULTIPART_UPLOAD_URL + parameters, HttpMethod.POST, entity, DriveFile.class, new Object[0]);
        return (DriveFile)response.getBody();
    }

    @Override
    public DriveFile createFileMetadata(DriveFile metadata) {
        return this.saveEntity(DRIVE_FILES_URL, metadata);
    }

    @Override
    public DriveFile createFolder(String parentId, String name) {
        return this.createFileMetadata(DriveFile.builder().setMimeType("application/vnd.google-apps.folder").setTitle(name).setParents(StringUtils.hasText((String)parentId) ? parentId : "root").build());
    }

    @Override
    public List<UserPermission> getPermissions(String fileId) {
        return this.getEntity(DRIVE_FILES_URL + fileId + PERMISSIONS, UserPermissionsList.class).getItems();
    }

    @Override
    public UserPermission addPermission(String fileId, UserPermission permission, boolean sendNotificationEmails) {
        return this.saveEntity(DRIVE_FILES_URL + fileId + PERMISSIONS + SEND_NOTIFICATION + sendNotificationEmails, permission);
    }

    @Override
    public UserPermission updatesPermission(String fileId, String permissionId, UserPermission permission) {
        Map<String, Object> patch = new PatchBuilder().set("role", permission.getRole()).set("additionalRoles", permission.getAdditionalRoles()).getMap();
        return this.patch(DRIVE_FILES_URL + fileId + PERMISSIONS + permissionId, patch, UserPermission.class);
    }

    @Override
    public void removePermission(String fileId, String permissionId) {
        this.restTemplate.delete(DRIVE_FILES_URL + fileId + PERMISSIONS + permissionId, new Object[0]);
    }

    @Override
    public List<FileRevision> getRevisions(String fileId) {
        return this.getEntity(DRIVE_FILES_URL + fileId + REVISIONS, FileRevisionsList.class).getItems();
    }

    @Override
    public FileRevision updateRevision(String fileId, String revisionId, FileRevision revision) {
        Map<String, Object> patch = new PatchBuilder().set("pinned", revision.isPinned()).set("publishAuto", revision.isPublishAuto()).set("published", revision.isPublished()).set("publishedOutsideDomain", revision.isPublishedOutsideDomain()).getMap();
        return this.patch(DRIVE_FILES_URL + fileId + REVISIONS + revisionId, patch, FileRevision.class);
    }

    @Override
    public FileCommentQueryBuilder fileCommentQueryBuilder(String fileId) {
        return new FileCommentQueryBuilderImpl(DRIVE_FILES_URL + fileId + COMMENTS, FileCommentsPage.class, this.restTemplate);
    }

    @Override
    public FileCommentsPage getComments(String fileId, String pageToken) {
        return (FileCommentsPage)((FileCommentQueryBuilder)this.fileCommentQueryBuilder(fileId).fromPage(pageToken)).getPage();
    }

    @Override
    public FileComment addComment(String fileId, FileComment comment) {
        return this.saveEntity(DRIVE_FILES_URL + fileId + COMMENTS, comment);
    }

    @Override
    public FileComment updateComment(String fileId, String commentId, FileComment comment) {
        Map<String, Object> patch = new PatchBuilder().set("content", comment.getContent()).getMap();
        return this.patch(DRIVE_FILES_URL + fileId + COMMENTS + commentId, patch, FileComment.class);
    }

    @Override
    public void removeComment(String fileId, String commentId) {
        this.restTemplate.delete(DRIVE_FILES_URL + fileId + COMMENTS + commentId, new Object[0]);
    }

    @Override
    public CommentReply addReply(String fileId, String commentId, CommentReply reply) {
        return this.saveEntity(DRIVE_FILES_URL + fileId + COMMENTS + commentId + REPLIES, reply);
    }

    @Override
    public CommentReply updateReply(String fileId, String commentId, String replyId, CommentReply reply) {
        Map<String, Object> patch = new PatchBuilder().set("content", reply.getContent()).set("verb", reply.getVerb()).getMap();
        return this.patch(DRIVE_FILES_URL + fileId + COMMENTS + commentId + REPLIES + replyId, patch, CommentReply.class);
    }

    @Override
    public void removeReply(String fileId, String commentId, String replyId) {
        this.restTemplate.delete(DRIVE_FILES_URL + fileId + COMMENTS + commentId + REPLIES + replyId, new Object[0]);
    }

    @Override
    public Resource downloadFile(String id) {
        return this.downloadFile(this.getFile(id));
    }

    @Override
    public Resource downloadFile(DriveFile file) {
        return (Resource)this.restTemplate.getForObject(file.getDownloadUrl(), Resource.class, new Object[0]);
    }

    @Override
    public List<FileProperty> getProperties(String fileId) {
        return this.getEntity(DRIVE_FILES_URL + fileId + PROPERTIES, FilePropertiesList.class).getItems();
    }

    @Override
    public FileProperty getProperty(String fileId, String propertyKey) {
        return this.getEntity(DRIVE_FILES_URL + fileId + PROPERTIES + propertyKey, FileProperty.class);
    }

    @Override
    public FileProperty addProperty(String fileId, FileProperty property) {
        return this.saveEntity(DRIVE_FILES_URL + fileId + PROPERTIES, property);
    }

    @Override
    public FileProperty updateProperty(String fileId, FileProperty property) {
        Map<String, Object> patch = new PatchBuilder().set("value", property.getValue()).set("visibility", property.getVisibility()).getMap();
        return this.patch(DRIVE_FILES_URL + fileId + PROPERTIES + property.getKey(), patch, FileProperty.class);
    }

    @Override
    public void removeProperty(String fileId, String propertyKey) {
        this.restTemplate.delete(DRIVE_FILES_URL + fileId + PROPERTIES + propertyKey, new Object[0]);
    }
}

