/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import com.github.springtestdbunit.DbUnitRunner;
import com.github.springtestdbunit.DbUnitTestContext;
import com.github.springtestdbunit.annotation.DbUnitConfiguration;
import com.github.springtestdbunit.bean.DatabaseDataSourceConnectionFactoryBean;
import com.github.springtestdbunit.dataset.DataSetLoader;
import com.github.springtestdbunit.dataset.FlatXmlDataSetLoader;
import com.github.springtestdbunit.operation.DatabaseOperationLookup;
import com.github.springtestdbunit.operation.DefaultDatabaseOperationLookup;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.IDatabaseConnection;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Conventions;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(DbUnitTestExecutionListener.class);
    private static final String[] COMMON_DATABASE_CONNECTION_BEAN_NAMES = new String[]{"dbUnitDatabaseConnection", "dataSource"};
    protected static final String CONNECTION_ATTRIBUTE = Conventions.getQualifiedAttributeName(DbUnitTestExecutionListener.class, (String)"connection");
    protected static final String DATA_SET_LOADER_ATTRIBUTE = Conventions.getQualifiedAttributeName(DbUnitTestExecutionListener.class, (String)"dataSetLoader");
    protected static final String DATABASE_OPERATION_LOOKUP_ATTRIBUTE = Conventions.getQualifiedAttributeName(DbUnitTestExecutionListener.class, (String)"databseOperationLookup");
    private static DbUnitRunner runner = new DbUnitRunner();

    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Preparing test instance " + testContext.getTestClass() + " for DBUnit"));
        }
        DbUnitTestContextAdapter dbUnitTestContext = new DbUnitTestContextAdapter(testContext);
        String databaseConnectionBeanName = null;
        Class dataSetLoaderClass = FlatXmlDataSetLoader.class;
        Class databaseOperationLookupClass = DefaultDatabaseOperationLookup.class;
        DbUnitConfiguration configuration = dbUnitTestContext.getTestClass().getAnnotation(DbUnitConfiguration.class);
        if (configuration != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Using @DbUnitConfiguration configuration");
            }
            databaseConnectionBeanName = configuration.databaseConnection();
            dataSetLoaderClass = configuration.dataSetLoader();
            databaseOperationLookupClass = configuration.databaseOperationLookup();
        }
        if (!StringUtils.hasLength(databaseConnectionBeanName)) {
            databaseConnectionBeanName = this.getDatabaseConnectionUsingCommonBeanNames(dbUnitTestContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBUnit tests will run using databaseConnection \"" + databaseConnectionBeanName + "\", datasets will be loaded using " + dataSetLoaderClass));
        }
        this.prepareDatabaseConnection(dbUnitTestContext, databaseConnectionBeanName);
        this.prepareDataSetLoader(dbUnitTestContext, dataSetLoaderClass);
        this.prepareDatabaseOperationLookup(dbUnitTestContext, databaseOperationLookupClass);
    }

    private String getDatabaseConnectionUsingCommonBeanNames(DbUnitTestContextAdapter testContext) {
        for (String beanName : COMMON_DATABASE_CONNECTION_BEAN_NAMES) {
            if (!testContext.getApplicationContext().containsBean(beanName)) continue;
            return beanName;
        }
        throw new IllegalStateException("Unable to find a DB Unit database connection, missing one the following beans: " + Arrays.asList(COMMON_DATABASE_CONNECTION_BEAN_NAMES));
    }

    private void prepareDatabaseConnection(DbUnitTestContextAdapter testContext, String databaseConnectionBeanName) throws Exception {
        Object databaseConnection = testContext.getApplicationContext().getBean(databaseConnectionBeanName);
        if (databaseConnection instanceof DataSource) {
            databaseConnection = DatabaseDataSourceConnectionFactoryBean.newConnection((DataSource)databaseConnection);
        }
        Assert.isInstanceOf(IDatabaseConnection.class, (Object)databaseConnection);
        testContext.setAttribute(CONNECTION_ATTRIBUTE, databaseConnection);
    }

    private void prepareDataSetLoader(DbUnitTestContextAdapter testContext, Class<? extends DataSetLoader> dataSetLoaderClass) {
        try {
            testContext.setAttribute(DATA_SET_LOADER_ATTRIBUTE, dataSetLoaderClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create data set loader instance for " + dataSetLoaderClass, e);
        }
    }

    private void prepareDatabaseOperationLookup(DbUnitTestContextAdapter testContext, Class<? extends DatabaseOperationLookup> databaseOperationLookupClass) {
        try {
            testContext.setAttribute(DATABASE_OPERATION_LOOKUP_ATTRIBUTE, databaseOperationLookupClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create database operation lookup instance for " + databaseOperationLookupClass, e);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        runner.beforeTestMethod(new DbUnitTestContextAdapter(testContext));
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        runner.afterTestMethod(new DbUnitTestContextAdapter(testContext));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DbUnitTestContextAdapter
    implements DbUnitTestContext {
        private static final Method GET_TEST_CLASS;
        private static final Method GET_TEST_METHOD;
        private static final Method GET_TEST_EXCEPTION;
        private static final Method GET_APPLICATION_CONTEXT;
        private static final Method GET_ATTRIBUTE;
        private static final Method SET_ATTRIBUTE;
        private TestContext testContext;

        public DbUnitTestContextAdapter(TestContext testContext) {
            this.testContext = testContext;
        }

        @Override
        public IDatabaseConnection getConnection() {
            return (IDatabaseConnection)this.getAttribute(CONNECTION_ATTRIBUTE);
        }

        @Override
        public DataSetLoader getDataSetLoader() {
            return (DataSetLoader)this.getAttribute(DATA_SET_LOADER_ATTRIBUTE);
        }

        @Override
        public DatabaseOperationLookup getDatbaseOperationLookup() {
            return (DatabaseOperationLookup)this.getAttribute(DATABASE_OPERATION_LOOKUP_ATTRIBUTE);
        }

        @Override
        public Class<?> getTestClass() {
            return (Class)ReflectionUtils.invokeMethod((Method)GET_TEST_CLASS, (Object)this.testContext);
        }

        @Override
        public Method getTestMethod() {
            return (Method)ReflectionUtils.invokeMethod((Method)GET_TEST_METHOD, (Object)this.testContext);
        }

        @Override
        public Throwable getTestException() {
            return (Throwable)ReflectionUtils.invokeMethod((Method)GET_TEST_EXCEPTION, (Object)this.testContext);
        }

        public ApplicationContext getApplicationContext() {
            return (ApplicationContext)ReflectionUtils.invokeMethod((Method)GET_APPLICATION_CONTEXT, (Object)this.testContext);
        }

        public Object getAttribute(String name) {
            return ReflectionUtils.invokeMethod((Method)GET_ATTRIBUTE, (Object)this.testContext, (Object[])new Object[]{name});
        }

        public void setAttribute(String name, Object value) {
            ReflectionUtils.invokeMethod((Method)SET_ATTRIBUTE, (Object)this.testContext, (Object[])new Object[]{name, value});
        }

        static {
            try {
                GET_TEST_CLASS = TestContext.class.getMethod("getTestClass", new Class[0]);
                GET_TEST_METHOD = TestContext.class.getMethod("getTestMethod", new Class[0]);
                GET_TEST_EXCEPTION = TestContext.class.getMethod("getTestException", new Class[0]);
                GET_APPLICATION_CONTEXT = TestContext.class.getMethod("getApplicationContext", new Class[0]);
                GET_ATTRIBUTE = TestContext.class.getMethod("getAttribute", String.class);
                SET_ATTRIBUTE = TestContext.class.getMethod("setAttribute", String.class, Object.class);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

