/*
 * Decompiled with CFR 0.152.
 */
package com.github.takayahilton.sqlformatter.core;

import com.github.takayahilton.sqlformatter.core.FormatConfig;
import com.github.takayahilton.sqlformatter.core.Indentation;
import com.github.takayahilton.sqlformatter.core.InlineBlock;
import com.github.takayahilton.sqlformatter.core.Params;
import com.github.takayahilton.sqlformatter.core.Token;
import com.github.takayahilton.sqlformatter.core.TokenTypes;
import com.github.takayahilton.sqlformatter.core.TokenTypes$BLOCK_COMMENT$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$CLOSE_PAREN$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$LINE_COMMENT$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$OPEN_PAREN$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$PLACEHOLDER$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$RESERVED$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$RESERVED_NEWLINE$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$RESERVED_TOPLEVEL$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$WHITESPACE$;
import com.github.takayahilton.sqlformatter.core.Tokenizer;
import com.github.takayahilton.sqlformatter.core.util.package$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\u0010!\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!)1\b\u0001C\u0001y!1\u0001\t\u0001Q\u0001\n\u0005Ca\u0001\u0012\u0001!\u0002\u0013)\u0005B\u0002%\u0001A\u0003%\u0011\n\u0003\u0004M\u0001\u0001\u0006K!\u0014\u0005\u0007'\u0002\u0001\u000b\u0015\u0002+\t\rq\u0003\u0001\u0015)\u0003^\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u0015A\b\u0001\"\u0003z\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e!9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0002bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!9\u00111\f\u0001\u0005\n\u0005u\u0003bBA2\u0001\u0011%\u0011Q\r\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002t\u0001!I!!\u001d\u0003\u0013\u0019{'/\\1ui\u0016\u0014(BA\u0011#\u0003\u0011\u0019wN]3\u000b\u0005\r\"\u0013\u0001D:rY\u001a|'/\\1ui\u0016\u0014(BA\u0013'\u00031!\u0018m[1zC\"LG\u000e^8o\u0015\t9\u0003&\u0001\u0004hSRDWO\u0019\u0006\u0002S\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\u0007\r4w\r\u0005\u00025k5\t\u0001%\u0003\u00027A\taai\u001c:nCR\u001cuN\u001c4jO\u0006IAo\\6f]&TXM\u001d\t\u0003ieJ!A\u000f\u0011\u0003\u0013Q{7.\u001a8ju\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002>}}\u0002\"\u0001\u000e\u0001\t\u000bI\u001a\u0001\u0019A\u001a\t\u000b]\u001a\u0001\u0019\u0001\u001d\u0002\u0017%tG-\u001a8uCRLwN\u001c\t\u0003i\tK!a\u0011\u0011\u0003\u0017%sG-\u001a8uCRLwN\\\u0001\fS:d\u0017N\\3CY>\u001c7\u000e\u0005\u00025\r&\u0011q\t\t\u0002\f\u0013:d\u0017N\\3CY>\u001c7.\u0001\u0004qCJ\fWn\u001d\t\u0003i)K!a\u0013\u0011\u0003\rA\u000b'/Y7t\u0003Q\u0001(/\u001a<j_V\u001c(+Z:feZ,GmV8sIB\u0019QF\u0014)\n\u0005=s#AB(qi&|g\u000e\u0005\u00025#&\u0011!\u000b\t\u0002\u0006)>\\WM\\\u0001\u0007i>\\WM\\:\u0011\u0007US\u0006+D\u0001W\u0015\t9\u0006,A\u0005j[6,H/\u00192mK*\u0011\u0011LL\u0001\u000bG>dG.Z2uS>t\u0017BA.W\u0005\u00191Vm\u0019;pe\u0006)\u0011N\u001c3fqB\u0011QFX\u0005\u0003?:\u00121!\u00138u\u0003\u00191wN]7biR\u0011!-\u001c\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015tS\"\u00014\u000b\u0005\u001dT\u0013A\u0002\u001fs_>$h(\u0003\u0002j]\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIg\u0006C\u0003o\u0015\u0001\u0007!-A\u0003rk\u0016\u0014\u00180A\u000ehKR4uN]7biR,G-U;fef4%o\\7U_.,gn]\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005Y\u0006twMC\u0001w\u0003\u0011Q\u0017M^1\n\u0005-\u001c\u0018!\u00054pe6\fG\u000fT5oK\u000e{W.\\3oiR\u0019\u0011O\u001f?\t\u000bmd\u0001\u0019\u0001)\u0002\u000bQ|7.\u001a8\t\u000b9d\u0001\u0019\u00012\u0002%\u0019|'/\\1u\u00052|7m[\"p[6,g\u000e\u001e\u000b\u0005c~\f\t\u0001C\u0003|\u001b\u0001\u0007\u0001\u000bC\u0003o\u001b\u0001\u0007!-A\u0007j]\u0012,g\u000e^\"p[6,g\u000e\u001e\u000b\u0004c\u0006\u001d\u0001BBA\u0005\u001d\u0001\u0007!-A\u0004d_6lWM\u001c;\u00025\u0019|'/\\1u)>\u0004H.\u001a<fYJ+7/\u001a:wK\u0012<vN\u001d3\u0015\u000bE\fy!!\u0005\t\u000bm|\u0001\u0019\u0001)\t\u000b9|\u0001\u0019\u00012\u00023\u0019|'/\\1u\u001d\u0016<H.\u001b8f%\u0016\u001cXM\u001d<fI^{'\u000f\u001a\u000b\u0006c\u0006]\u0011\u0011\u0004\u0005\u0006wB\u0001\r\u0001\u0015\u0005\u0006]B\u0001\rAY\u0001\u0013KF,\u0018\r\\5{K^C\u0017\u000e^3ta\u0006\u001cW\rF\u0002r\u0003?Aa!!\t\u0012\u0001\u0004\u0011\u0017AB:ue&tw-\u0001\rg_Jl\u0017\r^(qK:Lgn\u001a)be\u0016tG\u000f[3tKN$RAYA\u0014\u0003SAQa\u001f\nA\u0002ACQA\u001c\nA\u0002\t\f\u0001DZ8s[\u0006$8\t\\8tS:<\u0007+\u0019:f]RDWm]3t)\u0015\t\u0018qFA\u0019\u0011\u0015Y8\u00031\u0001Q\u0011\u0015q7\u00031\u0001c\u0003E1wN]7biBc\u0017mY3i_2$WM\u001d\u000b\u0006c\u0006]\u0012\u0011\b\u0005\u0006wR\u0001\r\u0001\u0015\u0005\u0006]R\u0001\rAY\u0001\fM>\u0014X.\u0019;D_6l\u0017\rF\u0003r\u0003\u007f\t\t\u0005C\u0003|+\u0001\u0007\u0001\u000bC\u0003o+\u0001\u0007!-\u0001\u000bg_Jl\u0017\r^,ji\"\u001c\u0006/Y2f\u0003\u001a$XM\u001d\u000b\u0006c\u0006\u001d\u0013\u0011\n\u0005\u0006wZ\u0001\r\u0001\u0015\u0005\u0006]Z\u0001\rAY\u0001\u0014M>\u0014X.\u0019;XSRDw.\u001e;Ta\u0006\u001cWm\u001d\u000b\u0006c\u0006=\u0013\u0011\u000b\u0005\u0006w^\u0001\r\u0001\u0015\u0005\u0006]^\u0001\rAY\u0001\u0011M>\u0014X.\u0019;XSRD7\u000b]1dKN$R!]A,\u00033BQa\u001f\rA\u0002ACQA\u001c\rA\u0002\t\fACZ8s[\u0006$\u0018+^3ssN+\u0007/\u0019:bi>\u0014H#B9\u0002`\u0005\u0005\u0004\"B>\u001a\u0001\u0004\u0001\u0006\"\u00028\u001a\u0001\u0004\u0011\u0017AC1eI:+w\u000f\\5oKR\u0019\u0011/a\u001a\t\u000b9T\u0002\u0019\u00012\u0002-Q\u0014\u0018.\u001c+sC&d\u0017N\\4XQ&$Xm\u001d9bG\u0016$2!]A7\u0011\u0015q7\u00041\u0001c\u0003i\u0001(/\u001a<j_V\u001chj\u001c8XQ&$Xm\u001d9bG\u0016$vn[3o+\u0005i\u0015!\u00049sKZLw.^:U_.,g\u000eF\u0002N\u0003oBa!!\u001f\u001e\u0001\u0004i\u0016AB8gMN,G\u000f")
public class Formatter {
    private final Tokenizer tokenizer;
    private final Indentation indentation;
    private final InlineBlock inlineBlock;
    private final Params params;
    private Option<Token> previousReservedWord;
    private Vector<Token> tokens;
    private int index;

    public String format(String query) {
        this.tokens = this.tokenizer.tokenize(query);
        String formattedQuery = this.getFormattedQueryFromTokens();
        return formattedQuery.trim();
    }

    private String getFormattedQueryFromTokens() {
        ObjectRef formattedQuery = ObjectRef.create((Object)"");
        ((Vector)this.tokens.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Formatter.$anonfun$getFormattedQueryFromTokens$1(this, formattedQuery, x0$1);
            return BoxedUnit.UNIT;
        });
        return (String)formattedQuery.elem;
    }

    private String formatLineComment(Token token, String query) {
        return this.addNewline(new StringBuilder(0).append(query).append(token.value()).toString());
    }

    private String formatBlockComment(Token token, String query) {
        return this.addNewline(new StringBuilder(0).append(this.addNewline(query)).append(this.indentComment(token.value())).toString());
    }

    private String indentComment(String comment) {
        return comment.replaceAll("\n", new StringBuilder(1).append("\n").append(this.indentation.getIndent()).toString());
    }

    private String formatToplevelReservedWord(Token token, String query) {
        this.indentation.decreaseTopLevel();
        String addedNewlineQuery = this.addNewline(query);
        this.indentation.increaseToplevel();
        String _query = new StringBuilder(0).append(addedNewlineQuery).append(this.equalizeWhitespace(token.value())).toString();
        return this.addNewline(_query);
    }

    private String formatNewlineReservedWord(Token token, String query) {
        return new StringBuilder(1).append(this.addNewline(query)).append(this.equalizeWhitespace(token.value())).append(" ").toString();
    }

    private String equalizeWhitespace(String string) {
        return string.replaceAll("\\s+", " ");
    }

    /*
     * WARNING - void declaration
     */
    private String formatOpeningParentheses(Token token, String query) {
        void var3_3;
        block1: {
            String _query = query;
            Set preserveWhitespaceFor = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TokenTypes[]{TokenTypes$WHITESPACE$.MODULE$, TokenTypes$OPEN_PAREN$.MODULE$, TokenTypes$LINE_COMMENT$.MODULE$}));
            if (!this.previousToken().exists((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)preserveWhitespaceFor.contains((Object)t.tokenType())))) {
                _query = package$.MODULE$.trimEnd(_query);
            }
            _query = new StringBuilder(0).append(_query).append(token.value()).toString();
            this.inlineBlock.beginIfPossible(this.tokens, this.index);
            if (this.inlineBlock.isActive()) break block1;
            this.indentation.increaseBlockLevel();
            _query = this.addNewline(_query);
        }
        return var3_3;
    }

    private String formatClosingParentheses(Token token, String query) {
        String string;
        if (this.inlineBlock.isActive()) {
            this.inlineBlock.end();
            string = this.formatWithSpaceAfter(token, query);
        } else {
            this.indentation.decreaseBlockLevel();
            string = this.formatWithSpaces(token, this.addNewline(query));
        }
        return string;
    }

    private String formatPlaceholder(Token token, String query) {
        return new StringBuilder(1).append(query).append(this.params.get(token)).append(" ").toString();
    }

    private String formatComma(Token token, String query) {
        String trimmed = new StringBuilder(1).append(this.trimTrailingWhitespace(query)).append(token.value()).append(" ").toString();
        return this.inlineBlock.isActive() ? trimmed : (this.previousReservedWord.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Formatter.$anonfun$formatComma$1(x$1))) ? trimmed : this.addNewline(trimmed));
    }

    private String formatWithSpaceAfter(Token token, String query) {
        return new StringBuilder(1).append(this.trimTrailingWhitespace(query)).append(token.value()).append(" ").toString();
    }

    private String formatWithoutSpaces(Token token, String query) {
        return new StringBuilder(0).append(this.trimTrailingWhitespace(query)).append(token.value()).toString();
    }

    private String formatWithSpaces(Token token, String query) {
        return new StringBuilder(1).append(query).append(token.value()).append(" ").toString();
    }

    private String formatQuerySeparator(Token token, String query) {
        return new StringBuilder(1).append(this.trimTrailingWhitespace(query)).append(token.value()).append("\n").toString();
    }

    private String addNewline(String query) {
        return new StringBuilder(1).append(package$.MODULE$.trimEnd(query)).append("\n").append(this.indentation.getIndent()).toString();
    }

    private String trimTrailingWhitespace(String query) {
        Option<Token> token = this.previousNonWhitespaceToken();
        return token.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Formatter.$anonfun$trimTrailingWhitespace$1(x$2))) ? new StringBuilder(1).append(package$.MODULE$.trimEnd(query)).append("\n").toString() : package$.MODULE$.trimEnd(query);
    }

    private Option<Token> previousNonWhitespaceToken() {
        int n = 1;
        while (this.previousToken(n).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Formatter.$anonfun$previousNonWhitespaceToken$1(x$3)))) {
            ++n;
        }
        return this.previousToken(n);
    }

    private Option<Token> previousToken(int offset) {
        return this.index - offset < 0 ? None$.MODULE$ : new Some(this.tokens.apply(this.index - offset));
    }

    private Option<Token> previousToken() {
        return this.previousToken(1);
    }

    public static final /* synthetic */ void $anonfun$getFormattedQueryFromTokens$1(Formatter $this, ObjectRef formattedQuery$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int _index;
            Token token = (Token)tuple2._1();
            $this.index = _index = tuple2._2$mcI$sp();
            TokenTypes tokenTypes = token.tokenType();
            if (TokenTypes$WHITESPACE$.MODULE$.equals(tokenTypes)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$LINE_COMMENT$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatLineComment(token, (String)formattedQuery$1.elem);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$BLOCK_COMMENT$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatBlockComment(token, (String)formattedQuery$1.elem);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$RESERVED_TOPLEVEL$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatToplevelReservedWord(token, (String)formattedQuery$1.elem);
                $this.previousReservedWord = new Some((Object)token);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$RESERVED_NEWLINE$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatNewlineReservedWord(token, (String)formattedQuery$1.elem);
                $this.previousReservedWord = new Some((Object)token);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$RESERVED$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatWithSpaces(token, (String)formattedQuery$1.elem);
                $this.previousReservedWord = new Some((Object)token);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$OPEN_PAREN$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatOpeningParentheses(token, (String)formattedQuery$1.elem);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$CLOSE_PAREN$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatClosingParentheses(token, (String)formattedQuery$1.elem);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TokenTypes$PLACEHOLDER$.MODULE$.equals(tokenTypes)) {
                formattedQuery$1.elem = $this.formatPlaceholder(token, (String)formattedQuery$1.elem);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string = token.value();
                String string2 = ",";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    formattedQuery$1.elem = $this.formatComma(token, (String)formattedQuery$1.elem);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string3 = token.value();
                    String string4 = ":";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        formattedQuery$1.elem = $this.formatWithSpaceAfter(token, (String)formattedQuery$1.elem);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string5 = token.value();
                        String string6 = ".";
                        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                            formattedQuery$1.elem = $this.formatWithoutSpaces(token, (String)formattedQuery$1.elem);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string7 = token.value();
                            String string8 = ";";
                            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                                formattedQuery$1.elem = $this.formatQuerySeparator(token, (String)formattedQuery$1.elem);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                formattedQuery$1.elem = $this.formatWithSpaces(token, (String)formattedQuery$1.elem);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$formatComma$1(Token x$1) {
        return x$1.value().matches("(?i)^LIMIT$");
    }

    public static final /* synthetic */ boolean $anonfun$trimTrailingWhitespace$1(Token x$2) {
        TokenTypes tokenTypes = x$2.tokenType();
        TokenTypes$LINE_COMMENT$ tokenTypes$LINE_COMMENT$ = TokenTypes$LINE_COMMENT$.MODULE$;
        return !(tokenTypes != null ? !tokenTypes.equals(tokenTypes$LINE_COMMENT$) : tokenTypes$LINE_COMMENT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$previousNonWhitespaceToken$1(Token x$3) {
        TokenTypes tokenTypes = x$3.tokenType();
        TokenTypes$WHITESPACE$ tokenTypes$WHITESPACE$ = TokenTypes$WHITESPACE$.MODULE$;
        return !(tokenTypes != null ? !tokenTypes.equals(tokenTypes$WHITESPACE$) : tokenTypes$WHITESPACE$ != null);
    }

    public Formatter(FormatConfig cfg, Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.indentation = new Indentation(cfg.indent());
        this.inlineBlock = new InlineBlock();
        this.params = cfg.params();
        this.previousReservedWord = None$.MODULE$;
        this.tokens = scala.package$.MODULE$.Vector().empty();
        this.index = 0;
    }
}

