/*
 * Decompiled with CFR 0.152.
 */
package com.github.takayahilton.sqlformatter.core;

import com.github.takayahilton.sqlformatter.core.DialectConfig;
import com.github.takayahilton.sqlformatter.core.Token;
import com.github.takayahilton.sqlformatter.core.Token$;
import com.github.takayahilton.sqlformatter.core.TokenTypes;
import com.github.takayahilton.sqlformatter.core.TokenTypes$BLOCK_COMMENT$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$CLOSE_PAREN$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$LINE_COMMENT$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$NUMBER$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$OPEN_PAREN$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$OPERATOR$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$PLACEHOLDER$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$RESERVED$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$RESERVED_NEWLINE$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$RESERVED_TOPLEVEL$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$STRING$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$WHITESPACE$;
import com.github.takayahilton.sqlformatter.core.TokenTypes$WORD$;
import com.github.takayahilton.sqlformatter.core.Tokenizer$;
import com.github.takayahilton.sqlformatter.core.package$;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5c\u0001B\"E\u0001=C\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t9\u0002\u0011\t\u0011)A\u00051\")Q\f\u0001C\u0001=\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB6\u0001A\u0003%1\rC\u0004m\u0001\t\u0007I\u0011\u00022\t\r5\u0004\u0001\u0015!\u0003d\u0011\u001dq\u0007A1A\u0005\n\tDaa\u001c\u0001!\u0002\u0013\u0019\u0007b\u00029\u0001\u0005\u0004%IA\u0019\u0005\u0007c\u0002\u0001\u000b\u0011B2\t\u000fI\u0004!\u0019!C\u0005E\"11\u000f\u0001Q\u0001\n\rDq\u0001\u001e\u0001C\u0002\u0013%!\r\u0003\u0004v\u0001\u0001\u0006Ia\u0019\u0005\bm\u0002\u0011\r\u0011\"\u0003c\u0011\u00199\b\u0001)A\u0005G\"9\u0001\u0010\u0001b\u0001\n\u0013\u0011\u0007BB=\u0001A\u0003%1\rC\u0004{\u0001\t\u0007I\u0011\u00022\t\rm\u0004\u0001\u0015!\u0003d\u0011\u001da\bA1A\u0005\n\tDa! \u0001!\u0002\u0013\u0019\u0007b\u0002@\u0001\u0005\u0004%IA\u0019\u0005\u0007\u007f\u0002\u0001\u000b\u0011B2\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\u0002\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\r\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\u0002\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003+\u0003A\u0011BAL\u0011\u001d\tY\n\u0001C\u0005\u0003;Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002(\u0002!I!!+\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u00111\u0017\u0001\u0005\n\u0005U\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!a3\u0001\t\u0013\ti\rC\u0004\u0002`\u0002!I!!9\t\u000f\u0005-\b\u0001\"\u0003\u0002n\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bbBA|\u0001\u0011%\u0011\u0011 \u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000fAqAa\u0003\u0001\t\u0013\u0011i\u0001C\u0004\u0003\u0012\u0001!IAa\u0005\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a!9!q\u0004\u0001\u0005\n\t\u0005ra\u0002B\u0019\t\"\u0005!1\u0007\u0004\u0007\u0007\u0012C\tA!\u000e\t\ru{D\u0011\u0001B\u001c\u0011\u001d\u0011Id\u0010C\u0005\u0005wAqA!\u0011@\t\u0013\u0011\u0019EA\u0005U_.,g.\u001b>fe*\u0011QIR\u0001\u0005G>\u0014XM\u0003\u0002H\u0011\u0006a1/\u001d7g_Jl\u0017\r\u001e;fe*\u0011\u0011JS\u0001\ri\u0006\\\u0017-_1iS2$xN\u001c\u0006\u0003\u00172\u000baaZ5uQV\u0014'\"A'\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0001\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&AB!osJ+g-A\u0002dM\u001e,\u0012\u0001\u0017\t\u00033jk\u0011\u0001R\u0005\u00037\u0012\u0013Q\u0002R5bY\u0016\u001cGoQ8oM&<\u0017\u0001B2gO\u0002\na\u0001P5oSRtDCA0a!\tI\u0006\u0001C\u0003W\u0007\u0001\u0007\u0001,\u0001\tX\u0011&#Vi\u0015)B\u0007\u0016{&+R$F1V\t1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006!A.\u00198h\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\rM#(/\u001b8h\u0003E9\u0006*\u0013+F'B\u000b5)R0S\u000b\u001e+\u0005\fI\u0001\r\u001dVk%)\u0012*`%\u0016;U\tW\u0001\u000e\u001dVk%)\u0012*`%\u0016;U\t\u0017\u0011\u0002\u001d=\u0003VIU!U\u001fJ{&+R$F1\u0006yq\nU#S\u0003R{%k\u0018*F\u000f\u0016C\u0006%\u0001\nM\u0013:+ulQ(N\u001b\u0016sEk\u0018*F\u000f\u0016C\u0016a\u0005'J\u001d\u0016{6iT'N\u000b:#vLU#H\u000bb\u0003\u0013a\u0006*F'\u0016\u0013f+\u0012#`)>\u0003F*\u0012,F\u0019~\u0013ViR#Y\u0003a\u0011ViU#S-\u0016#u\fV(Q\u0019\u00163V\tT0S\u000b\u001e+\u0005\fI\u0001\u0017%\u0016\u001bVI\u0015,F\t~sUi\u0016'J\u001d\u0016{&+R$F1\u00069\"+R*F%Z+Ei\u0018(F/2Ke*R0S\u000b\u001e+\u0005\fI\u0001\u0015%\u0016\u001bVI\u0015,F\t~\u0003F*Q%O?J+u)\u0012-\u0002+I+5+\u0012*W\u000b\u0012{\u0006\u000bT!J\u001d~\u0013ViR#YA\u0005Qqk\u0014*E?J+u)\u0012-\u0002\u0017]{%\u000bR0S\u000b\u001e+\u0005\fI\u0001\r'R\u0013\u0016JT$`%\u0016;U\tW\u0001\u000e'R\u0013\u0016JT$`%\u0016;U\t\u0017\u0011\u0002!=\u0003VIT0Q\u0003J+ej\u0018*F\u000f\u0016C\u0016!E(Q\u000b:{\u0006+\u0011*F\u001d~\u0013ViR#YA\u0005\t2\tT(T\u000b~\u0003\u0016IU#O?J+u)\u0012-\u0002%\rcujU#`!\u0006\u0013VIT0S\u000b\u001e+\u0005\fI\u0001\u001a\u0013:#U\tW#E?Bc\u0015iQ#I\u001f2#UIU0S\u000b\u001e+\u0005,\u0006\u0002\u0002\u0006A)\u0011+a\u0002\u0002\f%\u0019\u0011\u0011\u0002*\u0003\r=\u0003H/[8o!\u0011\ti!a\u0007\u000f\t\u0005=\u0011q\u0003\t\u0004\u0003#\u0011VBAA\n\u0015\r\t)BT\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e!+\u0001\u0004Qe\u0016$WMZ\u0005\u0004U\u0006u!bAA\r%\u0006Q\u0012J\u0014#F1\u0016#u\f\u0015'B\u0007\u0016Cu\n\u0014#F%~\u0013ViR#YA\u0005i\u0012\nR#O)~s\u0015)T#E?Bc\u0015iQ#I\u001f2#UIU0S\u000b\u001e+\u0005,\u0001\u0010J\t\u0016sEk\u0018(B\u001b\u0016#u\f\u0015'B\u0007\u0016Cu\n\u0014#F%~\u0013ViR#YA\u0005q2\u000b\u0016*J\u001d\u001e{f*Q'F\t~\u0003F*Q\"F\u0011>cE)\u0012*`%\u0016;U\tW\u0001 'R\u0013\u0016JT$`\u001d\u0006kU\tR0Q\u0019\u0006\u001bU\tS(M\t\u0016\u0013vLU#H\u000bb\u0003\u0013AF2sK\u0006$X\rT5oK\u000e{W.\\3oiJ+w-\u001a=\u0015\u0007\r\fi\u0003C\u0004\u00020\u0001\u0002\r!!\r\u0002!1Lg.Z\"p[6,g\u000e\u001e+za\u0016\u001c\bCBA\u001a\u0003{\tYA\u0004\u0003\u00026\u0005eb\u0002BA\t\u0003oI\u0011aU\u0005\u0004\u0003w\u0011\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\t\tE\u0001\u0003MSN$(bAA\u001e%\u000692M]3bi\u0016\u0014Vm]3sm\u0016$wk\u001c:e%\u0016<W\r\u001f\u000b\u0004G\u0006\u001d\u0003bBA%C\u0001\u0007\u0011\u0011G\u0001\u000ee\u0016\u001cXM\u001d<fI^{'\u000fZ:\u0002\u001f\r\u0014X-\u0019;f/>\u0014HMU3hKb$2aYA(\u0011\u001d\t\tF\ta\u0001\u0003c\tAb\u001d9fG&\fGn\u00115beN\f\u0011c\u0019:fCR,7\u000b\u001e:j]\u001e\u0014VmZ3y)\r\u0019\u0017q\u000b\u0005\b\u00033\u001a\u0003\u0019AA\u0019\u0003-\u0019HO]5oORK\b/Z:\u0002'\r\u0014X-\u0019;f'R\u0014\u0018N\\4QCR$XM\u001d8\u0015\t\u0005-\u0011q\f\u0005\b\u00033\"\u0003\u0019AA\u0019\u0003A\u0019'/Z1uKB\u000b'/\u001a8SK\u001e,\u0007\u0010F\u0002d\u0003KBq!a\u001a&\u0001\u0004\t\t$\u0001\u0004qCJ,gn]\u0001\ti>\\WM\\5{KR!\u0011QNA=!\u0019\t\u0019$a\u001c\u0002t%!\u0011\u0011OA!\u0005\u00191Vm\u0019;peB\u0019\u0011,!\u001e\n\u0007\u0005]DIA\u0003U_.,g\u000eC\u0004\u0002|\u0019\u0002\r!a\u0003\u0002\u000b%t\u0007/\u001e;\u0002\u0019\u001d,GOT3yiR{7.\u001a8\u0015\r\u0005\u0005\u00151QAC!\u0015\t\u0016qAA:\u0011\u001d\tYh\na\u0001\u0003\u0017Aq!a\"(\u0001\u0004\t\t)A\u0007qe\u00164\u0018n\\;t)>\\WM\\\u0001\u0013O\u0016$x\u000b[5uKN\u0004\u0018mY3U_.,g\u000e\u0006\u0003\u0002\u0002\u00065\u0005bBA>Q\u0001\u0007\u00111B\u0001\u0010O\u0016$8i\\7nK:$Hk\\6f]R!\u0011\u0011QAJ\u0011\u001d\tY(\u000ba\u0001\u0003\u0017\t1cZ3u\u0019&tWmQ8n[\u0016tG\u000fV8lK:$B!!!\u0002\u001a\"9\u00111\u0010\u0016A\u0002\u0005-\u0011\u0001F4fi\ncwnY6D_6lWM\u001c;U_.,g\u000e\u0006\u0003\u0002\u0002\u0006}\u0005bBA>W\u0001\u0007\u00111B\u0001\u000fO\u0016$8\u000b\u001e:j]\u001e$vn[3o)\u0011\t\t)!*\t\u000f\u0005mD\u00061\u0001\u0002\f\u0005\tr-\u001a;Pa\u0016t\u0007+\u0019:f]R{7.\u001a8\u0015\t\u0005\u0005\u00151\u0016\u0005\b\u0003wj\u0003\u0019AA\u0006\u0003I9W\r^\"m_N,\u0007+\u0019:f]R{7.\u001a8\u0015\t\u0005\u0005\u0015\u0011\u0017\u0005\b\u0003wr\u0003\u0019AA\u0006\u0003M9W\r\u001e)mC\u000e,\u0007n\u001c7eKJ$vn[3o)\u0011\t\t)a.\t\u000f\u0005mt\u00061\u0001\u0002\f\u0005ir-\u001a;JI\u0016tGOT1nK\u0012\u0004F.Y2fQ>dG-\u001a:U_.,g\u000e\u0006\u0003\u0002\u0002\u0006u\u0006bBA>a\u0001\u0007\u00111B\u0001\u001fO\u0016$8\u000b\u001e:j]\u001et\u0015-\\3e!2\f7-\u001a5pY\u0012,'\u000fV8lK:$B!!!\u0002D\"9\u00111P\u0019A\u0002\u0005-\u0011AG4fi&sG-\u001a=fIBc\u0017mY3i_2$WM\u001d+pW\u0016tG\u0003BAA\u0003\u0013Dq!a\u001f3\u0001\u0004\tY!\u0001\u000ehKR\u0004F.Y2fQ>dG-\u001a:U_.,gnV5uQ.+\u0017\u0010\u0006\u0005\u0002\u0002\u0006=\u0017\u0011[Ak\u0011\u001d\tYh\ra\u0001\u0003\u0017Aq!a54\u0001\u0004\tY!A\u0003sK\u001e,\u0007\u0010C\u0004\u0002XN\u0002\r!!7\u0002\u0011A\f'o]3LKf\u0004r!UAn\u0003\u0017\tY!C\u0002\u0002^J\u0013\u0011BR;oGRLwN\\\u0019\u00021\u001d,G/R:dCB,G\r\u00157bG\u0016Dw\u000e\u001c3fe.+\u0017\u0010F\u0003d\u0003G\f9\u000fC\u0004\u0002fR\u0002\r!a\u0003\u0002\u0007-,\u0017\u0010C\u0004\u0002jR\u0002\r!a\u0003\u0002\u0013E,x\u000e^3DQ\u0006\u0014\u0018AD4fi:+XNY3s)>\\WM\u001c\u000b\u0005\u0003\u0003\u000by\u000fC\u0004\u0002|U\u0002\r!a\u0003\u0002!\u001d,Go\u00149fe\u0006$xN\u001d+pW\u0016tG\u0003BAA\u0003kDq!a\u001f7\u0001\u0004\tY!\u0001\u000bhKR\u0014Vm]3sm\u0016$wk\u001c:e)>\\WM\u001c\u000b\u0007\u0003\u0003\u000bY0!@\t\u000f\u0005mt\u00071\u0001\u0002\f!9\u0011qQ\u001cA\u0002\u0005\u0005\u0015\u0001G4fiR{\u0007\u000f\\3wK2\u0014Vm]3sm\u0016$Gk\\6f]R!\u0011\u0011\u0011B\u0002\u0011\u001d\tY\b\u000fa\u0001\u0003\u0017\tqcZ3u\u001d\u0016<H.\u001b8f%\u0016\u001cXM\u001d<fIR{7.\u001a8\u0015\t\u0005\u0005%\u0011\u0002\u0005\b\u0003wJ\u0004\u0019AA\u0006\u0003U9W\r\u001e)mC&t'+Z:feZ,G\rV8lK:$B!!!\u0003\u0010!9\u00111\u0010\u001eA\u0002\u0005-\u0011\u0001D4fi^{'\u000f\u001a+pW\u0016tG\u0003BAA\u0005+Aq!a\u001f<\u0001\u0004\tY!A\u0007hKR4\u0015N]:u\u001b\u0006$8\r\u001b\u000b\u0007\u0003\u000b\u0011YB!\b\t\u000f\u0005mD\b1\u0001\u0002\f!9\u00111\u001b\u001fA\u0002\u0005-\u0011\u0001F4fiR{7.\u001a8P]\u001aK'o\u001d;NCR\u001c\u0007\u000e\u0006\u0005\u0002\u0002\n\r\"Q\u0005B\u0018\u0011\u001d\tY(\u0010a\u0001\u0003\u0017AqAa\n>\u0001\u0004\u0011I#A\u0005u_.,g\u000eV=qKB\u0019\u0011La\u000b\n\u0007\t5BI\u0001\u0006U_.,g\u000eV=qKNDq!a5>\u0001\u0004\tY!A\u0005U_.,g.\u001b>feB\u0011\u0011lP\n\u0003\u007fA#\"Aa\r\u0002\u0017\u0015\u001c8-\u00199f!\u0006\u0014XM\u001c\u000b\u0005\u0003\u0017\u0011i\u0004C\u0004\u0003@\u0005\u0003\r!a\u0003\u0002\u000bA\f'/\u001a8\u0002-\r\u0014X-\u0019;f!2\f7-\u001a5pY\u0012,'OU3hKb$b!!\u0002\u0003F\t%\u0003b\u0002B$\u0005\u0002\u0007\u0011\u0011G\u0001\u0006if\u0004Xm\u001d\u0005\b\u0005\u0017\u0012\u0005\u0019AA\u0006\u0003\u001d\u0001\u0018\r\u001e;fe:\u0004")
public class Tokenizer {
    private final DialectConfig cfg;
    private final String WHITESPACE_REGEX;
    private final String NUMBER_REGEX;
    private final String OPERATOR_REGEX;
    private final String LINE_COMMENT_REGEX;
    private final String RESERVED_TOPLEVEL_REGEX;
    private final String RESERVED_NEWLINE_REGEX;
    private final String RESERVED_PLAIN_REGEX;
    private final String WORD_REGEX;
    private final String STRING_REGEX;
    private final String OPEN_PAREN_REGEX;
    private final String CLOSE_PAREN_REGEX;
    private final Option<String> INDEXED_PLACEHOLDER_REGEX;
    private final Option<String> IDENT_NAMED_PLACEHOLDER_REGEX;
    private final Option<String> STRING_NAMED_PLACEHOLDER_REGEX;

    public DialectConfig cfg() {
        return this.cfg;
    }

    private String WHITESPACE_REGEX() {
        return this.WHITESPACE_REGEX;
    }

    private String NUMBER_REGEX() {
        return this.NUMBER_REGEX;
    }

    private String OPERATOR_REGEX() {
        return this.OPERATOR_REGEX;
    }

    private String LINE_COMMENT_REGEX() {
        return this.LINE_COMMENT_REGEX;
    }

    private String RESERVED_TOPLEVEL_REGEX() {
        return this.RESERVED_TOPLEVEL_REGEX;
    }

    private String RESERVED_NEWLINE_REGEX() {
        return this.RESERVED_NEWLINE_REGEX;
    }

    private String RESERVED_PLAIN_REGEX() {
        return this.RESERVED_PLAIN_REGEX;
    }

    private String WORD_REGEX() {
        return this.WORD_REGEX;
    }

    private String STRING_REGEX() {
        return this.STRING_REGEX;
    }

    private String OPEN_PAREN_REGEX() {
        return this.OPEN_PAREN_REGEX;
    }

    private String CLOSE_PAREN_REGEX() {
        return this.CLOSE_PAREN_REGEX;
    }

    private Option<String> INDEXED_PLACEHOLDER_REGEX() {
        return this.INDEXED_PLACEHOLDER_REGEX;
    }

    private Option<String> IDENT_NAMED_PLACEHOLDER_REGEX() {
        return this.IDENT_NAMED_PLACEHOLDER_REGEX;
    }

    private Option<String> STRING_NAMED_PLACEHOLDER_REGEX() {
        return this.STRING_NAMED_PLACEHOLDER_REGEX;
    }

    private String createLineCommentRegex(List<String> lineCommentTypes) {
        return String.format("^((?:%s).*?(?:\n|$))", lineCommentTypes.map((Function1 & Serializable)s -> com.github.takayahilton.sqlformatter.core.util.package$.MODULE$.escapeRegExp((String)s)).mkString("|"));
    }

    private String createReservedWordRegex(List<String> reservedWords) {
        String reservedWordsPattern = reservedWords.mkString("|").replaceAll(" ", "\\\\s+");
        return new StringBuilder(9).append("(?i)^(").append(reservedWordsPattern).append(")\\b").toString();
    }

    private String createWordRegex(List<String> specialChars) {
        return new StringBuilder(8).append("^([\\w").append(specialChars.mkString()).append("]+)").toString();
    }

    private String createStringRegex(List<String> stringTypes) {
        return new StringBuilder(3).append("^(").append(this.createStringPattern(stringTypes)).append(")").toString();
    }

    private String createStringPattern(List<String> stringTypes) {
        Map patterns = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"``", (Object)"((`[^`]*($|`))+)"), new Tuple2((Object)"[]", (Object)"((\\[[^\\]]*($|\\]))(\\][^\\]]*($|\\]))*)"), new Tuple2((Object)"\"\"", (Object)"((\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*(\"|$))+)"), new Tuple2((Object)"''", (Object)"(('[^'\\\\]*(?:\\\\.[^'\\\\]*)*('|$))+)"), new Tuple2((Object)"N''", (Object)"((N'[^N'\\\\]*(?:\\\\.[^N'\\\\]*)*('|$))+)")}));
        return stringTypes.flatMap((Function1 & Serializable)key -> patterns.get(key)).mkString("|");
    }

    private String createParenRegex(List<String> parens) {
        return new StringBuilder(7).append("(?i)^(").append(parens.map((Function1 & Serializable)paren -> Tokenizer$.MODULE$.com$github$takayahilton$sqlformatter$core$Tokenizer$$escapeParen((String)paren)).mkString("|")).append(")").toString();
    }

    public Vector<Token> tokenize(String input) {
        return this.go$1(input, (Option)None$.MODULE$, new VectorBuilder());
    }

    private Option<Token> getNextToken(String input, Option<Token> previousToken) {
        return this.getWhitespaceToken(input).orElse((Function0 & Serializable)() -> this.getCommentToken(input)).orElse((Function0 & Serializable)() -> this.getStringToken(input)).orElse((Function0 & Serializable)() -> this.getOpenParenToken(input)).orElse((Function0 & Serializable)() -> this.getCloseParenToken(input)).orElse((Function0 & Serializable)() -> this.getPlaceholderToken(input)).orElse((Function0 & Serializable)() -> this.getNumberToken(input)).orElse((Function0 & Serializable)() -> this.getReservedWordToken(input, previousToken)).orElse((Function0 & Serializable)() -> this.getWordToken(input)).orElse((Function0 & Serializable)() -> this.getOperatorToken(input));
    }

    private Option<Token> getWhitespaceToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$WHITESPACE$.MODULE$, this.WHITESPACE_REGEX());
    }

    private Option<Token> getCommentToken(String input) {
        return this.getLineCommentToken(input).orElse((Function0 & Serializable)() -> this.getBlockCommentToken(input));
    }

    private Option<Token> getLineCommentToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$LINE_COMMENT$.MODULE$, this.LINE_COMMENT_REGEX());
    }

    private Option<Token> getBlockCommentToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$BLOCK_COMMENT$.MODULE$, package$.MODULE$.BLOCK_COMMENT_REGEX());
    }

    private Option<Token> getStringToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$STRING$.MODULE$, this.STRING_REGEX());
    }

    private Option<Token> getOpenParenToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$OPEN_PAREN$.MODULE$, this.OPEN_PAREN_REGEX());
    }

    private Option<Token> getCloseParenToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$CLOSE_PAREN$.MODULE$, this.CLOSE_PAREN_REGEX());
    }

    private Option<Token> getPlaceholderToken(String input) {
        return this.getIdentNamedPlaceholderToken(input).orElse((Function0 & Serializable)() -> this.getStringNamedPlaceholderToken(input)).orElse((Function0 & Serializable)() -> this.getIndexedPlaceholderToken(input));
    }

    private Option<Token> getIdentNamedPlaceholderToken(String input) {
        return this.IDENT_NAMED_PLACEHOLDER_REGEX().flatMap((Function1 & Serializable)x$1 -> this.getPlaceholderTokenWithKey(input, (String)x$1, (Function1<String, String>)(Function1 & Serializable)x$2 -> x$2.substring(1)));
    }

    private Option<Token> getStringNamedPlaceholderToken(String input) {
        return this.STRING_NAMED_PLACEHOLDER_REGEX().flatMap((Function1 & Serializable)x$3 -> this.getPlaceholderTokenWithKey(input, (String)x$3, (Function1<String, String>)(Function1 & Serializable)v -> this.getEscapedPlaceholderKey(v.substring(2, v.length() - 1), v.substring(v.length() - 1))));
    }

    private Option<Token> getIndexedPlaceholderToken(String input) {
        return this.INDEXED_PLACEHOLDER_REGEX().flatMap((Function1 & Serializable)x$4 -> this.getPlaceholderTokenWithKey(input, (String)x$4, (Function1<String, String>)(Function1 & Serializable)x$5 -> x$5.substring(1)));
    }

    private Option<Token> getPlaceholderTokenWithKey(String input, String regex, Function1<String, String> parseKey) {
        Option<Token> token = this.getTokenOnFirstMatch(input, TokenTypes$PLACEHOLDER$.MODULE$, regex);
        return token.map((Function1 & Serializable)t -> t.withKey((String)parseKey.apply((Object)t.value())));
    }

    private String getEscapedPlaceholderKey(String key, String quoteChar) {
        return key.replaceAll(new StringBuilder(0).append(com.github.takayahilton.sqlformatter.core.util.package$.MODULE$.escapeRegExp("\\")).append(quoteChar).toString(), quoteChar);
    }

    private Option<Token> getNumberToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$NUMBER$.MODULE$, this.NUMBER_REGEX());
    }

    private Option<Token> getOperatorToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$OPERATOR$.MODULE$, this.OPERATOR_REGEX());
    }

    private Option<Token> getReservedWordToken(String input, Option<Token> previousToken) {
        return previousToken.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Tokenizer.$anonfun$getReservedWordToken$1(x$6))) ? None$.MODULE$ : this.getToplevelReservedToken(input).orElse((Function0 & Serializable)() -> this.getNewlineReservedToken(input)).orElse((Function0 & Serializable)() -> this.getPlainReservedToken(input));
    }

    private Option<Token> getToplevelReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$RESERVED_TOPLEVEL$.MODULE$, this.RESERVED_TOPLEVEL_REGEX());
    }

    private Option<Token> getNewlineReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$RESERVED_NEWLINE$.MODULE$, this.RESERVED_NEWLINE_REGEX());
    }

    private Option<Token> getPlainReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$RESERVED$.MODULE$, this.RESERVED_PLAIN_REGEX());
    }

    private Option<Token> getWordToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes$WORD$.MODULE$, this.WORD_REGEX());
    }

    private Option<String> getFirstMatch(String input, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(input);
        return matcher.find() ? new Some((Object)matcher.group()) : None$.MODULE$;
    }

    private Option<Token> getTokenOnFirstMatch(String input, TokenTypes tokenType, String regex) {
        Option<String> matches = this.getFirstMatch(input, regex);
        return matches.map((Function1 & Serializable)x$7 -> Token$.MODULE$.apply(tokenType, (String)x$7));
    }

    private final Vector go$1(String input, Option previousToken, VectorBuilder tokens) {
        while (true) {
            block5: {
                String string;
                switch ((string = input) == null ? 0 : string.hashCode()) {
                    case 0: {
                        if ("".equals(string)) {
                            break;
                        }
                        break block5;
                    }
                    default: {
                        break block5;
                    }
                }
                break;
            }
            Token token = (Token)this.getNextToken(input, (Option<Token>)previousToken).get();
            tokens = (VectorBuilder)tokens.$plus$eq((Object)token);
            previousToken = new Some((Object)token);
            input = input.substring(token.value().length());
        }
        Vector vector = tokens.result();
        return vector;
    }

    public static final /* synthetic */ boolean $anonfun$getReservedWordToken$1(Token x$6) {
        String string = x$6.value();
        String string2 = ".";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Tokenizer(DialectConfig cfg) {
        this.cfg = cfg;
        this.WHITESPACE_REGEX = "^(\\s+)";
        this.NUMBER_REGEX = "^((-\\s*)?[0-9]+(\\.[0-9]+)?|0x[0-9a-fA-F]+|0b[01]+)\\b";
        this.OPERATOR_REGEX = "^(!=|<>|==|<=|>=|!<|!>|\\|\\||::|->>|->|~~\\*|~~|!~~\\*|!~~|~\\*|!~\\*|!~|.)";
        this.LINE_COMMENT_REGEX = this.createLineCommentRegex(cfg.lineCommentTypes());
        this.RESERVED_TOPLEVEL_REGEX = this.createReservedWordRegex(cfg.reservedToplevelWords());
        this.RESERVED_NEWLINE_REGEX = this.createReservedWordRegex(cfg.reservedNewlineWords());
        this.RESERVED_PLAIN_REGEX = this.createReservedWordRegex(cfg.reservedWords());
        this.WORD_REGEX = this.createWordRegex(cfg.specialWordChars());
        this.STRING_REGEX = this.createStringRegex(cfg.stringTypes());
        this.OPEN_PAREN_REGEX = this.createParenRegex(cfg.openParens());
        this.CLOSE_PAREN_REGEX = this.createParenRegex(cfg.closeParens());
        this.INDEXED_PLACEHOLDER_REGEX = Tokenizer$.MODULE$.com$github$takayahilton$sqlformatter$core$Tokenizer$$createPlaceholderRegex(cfg.indexedPlaceholderTypes(), "[0-9]*");
        this.IDENT_NAMED_PLACEHOLDER_REGEX = Tokenizer$.MODULE$.com$github$takayahilton$sqlformatter$core$Tokenizer$$createPlaceholderRegex(cfg.namedPlaceholderTypes(), "[a-zA-Z0-9._$]+");
        this.STRING_NAMED_PLACEHOLDER_REGEX = Tokenizer$.MODULE$.com$github$takayahilton$sqlformatter$core$Tokenizer$$createPlaceholderRegex(cfg.namedPlaceholderTypes(), this.createStringPattern(cfg.stringTypes()));
    }
}

