/*
 * Decompiled with CFR 0.152.
 */
package theleo.jstruct.hidden;

import java.lang.reflect.Field;
import sun.misc.Unsafe;
import theleo.jstruct.NullPointerDereference;
import theleo.jstruct.StackOutOfMemory;
import theleo.jstruct.WildPointerException;
import theleo.jstruct.hidden.AutoArray;
import theleo.jstruct.hidden.AutoHybrid;
import theleo.jstruct.hidden.CompileException;
import theleo.jstruct.hidden.Stack;

public class Mem0 {
    public static long STACK_INIT_SIZE = 1024L;
    public static long STACK_MAX_SIZE = 262144L;
    public static int STACK_INIT_OBJ_SIZE = 32;
    public static int STACK_MAX_OBJ_SIZE = 262144;
    public static final Unsafe u = Mem0.getUnsafe();
    private static final long BLOCKER_LOCK_OFFSET;
    static final Object allocOwner;
    static final Object ownersDataLock;
    static Object[][] ownersData;
    static int lastFreeOwner;

    public static <T> T getObject(long addr, int offset) {
        return Mem0.getObject0(u.getInt(addr), u.getInt(addr + 4L) + offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getObject0(int owner, int i) {
        Object[][] a = ownersData;
        if (owner >= a.length) {
            Object object = ownersDataLock;
            synchronized (object) {
                Object[][] c = ownersData;
                if (owner >= c.length) {
                    throw new WildPointerException();
                }
                return (T)c[owner][i];
            }
        }
        return (T)a[owner][i];
    }

    public static void putObject(long addr, int offset, Object o) {
        Mem0.putObject0(u.getInt(addr), u.getInt(addr + 4L) + offset, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObject0(int owner, int i, Object o) {
        Object[][] a = ownersData;
        if (owner >= a.length) {
            Object object = ownersDataLock;
            synchronized (object) {
                Object[][] c = ownersData;
                if (owner >= c.length) {
                    throw new WildPointerException();
                }
                c[owner][i] = o;
            }
        }
        a[owner][i] = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int allocObjectArray(Object[] arr) {
        Object object = allocOwner;
        synchronized (object) {
            int i;
            int found = -1;
            Object[][] odata = ownersData;
            int l = lastFreeOwner;
            int size = odata.length;
            for (i = l; i < size; ++i) {
                if (odata[i] != null) continue;
                found = i;
                break;
            }
            if (found == -1) {
                for (i = 0; i < l; ++i) {
                    if (odata[i] != null) continue;
                    found = i;
                    break;
                }
            }
            if (found == -1) {
                Object[][] grow = new Object[size << 1][];
                System.arraycopy(odata, 0, grow, 0, size);
                odata = grow;
                size = grow.length;
                Object object2 = ownersDataLock;
                synchronized (object2) {
                    ownersData = grow;
                }
                found = size;
            }
            odata[found] = arr;
            lastFreeOwner = found + 1;
            return found;
        }
    }

    public static long allocHybOnStack(long addr, int posObj, int hybridIndex, int ... ownerOffet) {
        for (int i = 0; i < ownerOffet.length; i += 2) {
            int off = ownerOffet[i];
            int count = ownerOffet[i + 1];
            u.putInt(addr + (long)off, hybridIndex);
            u.putInt(addr + (long)off + 4L, posObj);
            posObj += count;
        }
        return addr;
    }

    public static AutoHybrid allocHybrid(long length, long structSize, boolean zero, int glObjCount, int ... ownerOffet) {
        int found;
        long allocSize = length * structSize;
        long base = Mem0.alloc(allocSize);
        if (zero) {
            u.setMemory(base, allocSize, (byte)0);
        }
        AutoHybrid auto = new AutoHybrid(base, length, structSize, glObjCount);
        if (length == 0L) {
            return auto;
        }
        auto.hybridIndex = found = Mem0.allocObjectArray(auto.hybridData);
        int index = 0;
        for (long l = 0L; l < length; ++l) {
            for (int i = 0; i < ownerOffet.length; i += 2) {
                int off = ownerOffet[i];
                int count = ownerOffet[i + 1];
                u.putInt(base + (long)off, found);
                u.putInt(base + (long)off + 4L, index);
                index += count;
            }
            base += structSize;
        }
        return auto;
    }

    public static AutoArray alloc(long length, long structSize, boolean zero) {
        long size = length * structSize;
        long base = Mem0.alloc(size);
        if (zero) {
            u.setMemory(base, size, (byte)0);
        }
        return new AutoArray(base, length, structSize);
    }

    public static long alloc(long size) {
        return u.allocateMemory(size);
    }

    public static void freeHybrid(long ptr, int hybridIndex) {
        u.freeMemory(ptr);
        Mem0.ownersData[hybridIndex] = null;
    }

    public static void freeObjectArray(int hybridIndex) {
        Mem0.ownersData[hybridIndex] = null;
    }

    public static void free(long ptr) {
        u.freeMemory(ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stack stack() {
        Thread t = Thread.currentThread();
        Object o = u.getObject(t, BLOCKER_LOCK_OFFSET);
        if (o instanceof Stack) {
            return (Stack)o;
        }
        Stack s = new Stack(STACK_INIT_SIZE, STACK_INIT_OBJ_SIZE);
        Object object = o;
        synchronized (object) {
            u.putObject(t, BLOCKER_LOCK_OFFSET, s);
        }
        return s;
    }

    public static void stackGrowArray(Stack s) {
        long size = s.hybridData.length << 1;
        if (size > (long)STACK_MAX_OBJ_SIZE) {
            throw new StackOutOfMemory();
        }
        Object[] arr = new Object[(int)size];
        System.arraycopy(s.hybridData, 0, arr, 0, s.hybridData.length);
        s.hybridData = arr;
        Mem0.ownersData[s.hybridIndex] = arr;
    }

    public static <T> T as(Object o) {
        return (T)o;
    }

    public static <T> T stackRaw(Class<T> classLiteral) {
        throw new CompileException();
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNull(long o) {
        return (o = u.getLong(o)) == 0L;
    }

    public static long ref(long l) {
        if (l == 0L) {
            throw new NullPointerDereference();
        }
        return l;
    }

    public static long ptr(long l) {
        if ((l = u.getLong(l)) == 0L) {
            throw new NullPointerDereference();
        }
        return l;
    }

    public static long copyMemory(long from, long to, long bytes) {
        u.copyMemory(from, to, bytes);
        return to;
    }

    public static long copyHybrid(long from, long to, long bytes, int ... ownerOffet) {
        int oFrom = u.getInt(from + (long)ownerOffet[0]);
        int oFromI = u.getInt(from + (long)ownerOffet[0] + 4L);
        int oTo = u.getInt(to + (long)ownerOffet[0]);
        int oToI = u.getInt(to + (long)ownerOffet[0] + 4L);
        int k = 0;
        int add = 0;
        int i = 0;
        while ((long)i < bytes) {
            if (k < ownerOffet.length && ownerOffet[k] == i) {
                int count = ownerOffet[k + 1];
                for (int j = 0; j < count; ++j) {
                    Mem0.putObject0(oTo, oToI + add, Mem0.getObject0(oFrom, oFromI + add));
                    ++add;
                }
                k += 2;
            } else {
                u.copyMemory(from + (long)i, to + (long)i, (long)(i + 8) > bytes ? bytes - (long)i : 8L);
            }
            i += 8;
        }
        return to;
    }

    public static boolean getBoolean(long addr) {
        return u.getByte(addr) != 0;
    }

    public static boolean putBoolean(long addr, boolean f) {
        u.putByte(addr, f ? (byte)1 : 0);
        return f;
    }

    private static Unsafe getUnsafe() {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            return (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        Field f = null;
        long offset = 0L;
        try {
            f = Thread.class.getDeclaredField("blockerLock");
            f.setAccessible(true);
            offset = u.objectFieldOffset(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not initialize");
        }
        BLOCKER_LOCK_OFFSET = offset;
        allocOwner = new Object();
        ownersDataLock = new Object();
        ownersData = new Object[128][];
        lastFreeOwner = 0;
    }
}

