/*
 * Decompiled with CFR 0.152.
 */
package theleo.jstruct.hidden;

import theleo.jstruct.StackOutOfMemory;
import theleo.jstruct.hidden.Mem0;

public final class Stack {
    public long base;
    public long baseEnd;
    public long position;
    private long pointer;
    public int positionObjs;
    public int hybridIndex;
    public Object[] hybridData;
    private static final long PTR_OFFSET;

    public Stack(long size, int objSize) {
        this.pointer = Mem0.u.allocateMemory(size);
        this.hybridData = new Object[objSize];
        this.hybridIndex = Mem0.allocObjectArray(this.hybridData);
        this.base = this.pointer;
        this.baseEnd = this.pointer + size;
        this.position = this.pointer;
        this.positionObjs = 0;
    }

    public final long getBase() {
        return this.base;
    }

    public long get(int bytes) {
        long l = this.position;
        long add = l + (long)bytes;
        if (add >= this.baseEnd) {
            this.grow();
        }
        this.position = add;
        return l;
    }

    private void grow() {
        long size = this.baseEnd - this.base << 1;
        if (size > Mem0.STACK_MAX_SIZE) {
            throw new StackOutOfMemory();
        }
        this.base = this.pointer = Mem0.u.reallocateMemory(this.pointer, size);
        this.baseEnd = this.pointer + size;
        this.position = this.pointer;
    }

    public void pop(long p) {
        this.position = p;
    }

    public int getObj(int objs) {
        int i = this.positionObjs;
        int add = i + objs;
        if (add >= this.hybridData.length) {
            this.growArray();
        }
        this.positionObjs = add;
        return i;
    }

    private void growArray() {
        Mem0.stackGrowArray(this);
    }

    public void pop(long p, int obj) {
        this.position = p;
        int to = this.positionObjs;
        for (int i = obj; i < to; ++i) {
            this.hybridData[i] = null;
        }
        this.positionObjs = obj;
    }

    protected void finalize() {
        long value = Mem0.u.getAndSetLong(this, PTR_OFFSET, 0L);
        if (value != 0L) {
            Mem0.u.freeMemory(value);
            Mem0.freeObjectArray(this.hybridIndex);
            this.hybridIndex = -1;
        }
    }

    static {
        long val;
        try {
            val = Mem0.u.objectFieldOffset(Stack.class.getDeclaredField("pointer"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            long val2 = 32L;
            throw new IllegalArgumentException("Could not initialize");
        }
        PTR_OFFSET = val;
    }
}

