/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.webapp;

import java.io.IOException;
import java.util.Map;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;
import wiremock.org.eclipse.jetty.util.resource.Resource;
import wiremock.org.eclipse.jetty.webapp.AbstractConfiguration;
import wiremock.org.eclipse.jetty.webapp.WebAppClassLoader;
import wiremock.org.eclipse.jetty.webapp.WebAppContext;
import wiremock.org.eclipse.jetty.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(JettyWebXmlConfiguration.class);
    @Deprecated
    public static final String PROPERTY_THIS_WEB_INF_URL = "this.web-inf.url";
    public static final String PROPERTY_WEB_INF_URI = "web-inf.uri";
    public static final String PROPERTY_WEB_INF = "web-inf";
    public static final String XML_CONFIGURATION = "wiremock.org.eclipse.jetty.webapp.JettyWebXmlConfiguration";
    public static final String JETTY_WEB_XML = "jetty-web.xml";

    @Override
    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        LOG.debug("Configuring web-jetty.xml", new Object[0]);
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty8-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath(JETTY_WEB_XML);
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Configure: " + jetty, new Object[0]);
                }
                Object xml_attr = context.getAttribute(XML_CONFIGURATION);
                context.removeAttribute(XML_CONFIGURATION);
                XmlConfiguration jetty_config = xml_attr instanceof XmlConfiguration ? (XmlConfiguration)xml_attr : new XmlConfiguration(jetty.getURI().toURL());
                this.setupXmlConfiguration(context, jetty_config, web_inf);
                try {
                    WebAppClassLoader.runWithServerClassAccess(() -> {
                        jetty_config.configure(context);
                        return null;
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error applying {}", jetty);
                    throw e;
                }
            }
        }
    }

    private void setupXmlConfiguration(WebAppContext context, XmlConfiguration jetty_config, Resource web_inf) throws IOException {
        jetty_config.setJettyStandardIdsAndProperties(context.getServer(), null);
        Map<String, String> props = jetty_config.getProperties();
        props.put(PROPERTY_THIS_WEB_INF_URL, web_inf.getURI().toString());
        props.put(PROPERTY_WEB_INF_URI, XmlConfiguration.normalizeURI(web_inf.getURI().toString()));
        props.put(PROPERTY_WEB_INF, web_inf.toString());
    }
}

