/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import wiremock.com.github.jknack.handlebars.internal.HbsParser;
import wiremock.com.github.jknack.handlebars.internal.HbsParserBaseListener;
import wiremock.com.github.jknack.handlebars.internal.antlr.CommonToken;
import wiremock.com.github.jknack.handlebars.internal.antlr.CommonTokenStream;
import wiremock.com.github.jknack.handlebars.internal.antlr.Token;
import wiremock.com.github.jknack.handlebars.internal.lang3.StringUtils;

public class WhiteSpaceControl
extends HbsParserBaseListener {
    private CommonTokenStream tokens;

    public WhiteSpaceControl(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    @Override
    public void enterBlock(HbsParser.BlockContext ctx) {
        this.trim(ctx.start, ctx.END(0).getSymbol());
    }

    @Override
    public void enterElseStmt(HbsParser.ElseStmtContext ctx) {
        this.trim(ctx.start, ctx.END().getSymbol());
    }

    @Override
    public void enterElseStmtChain(HbsParser.ElseStmtChainContext ctx) {
        this.trim(ctx.start, ctx.END().getSymbol());
    }

    @Override
    public void exitBlock(HbsParser.BlockContext ctx) {
        this.trim(ctx.END_BLOCK().getSymbol(), ctx.END(1).getSymbol());
    }

    @Override
    public void enterComment(HbsParser.CommentContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterPartial(HbsParser.PartialContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterDelimiters(HbsParser.DelimitersContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterUnless(HbsParser.UnlessContext ctx) {
        this.trim(ctx.start, ctx.END().get(0).getSymbol());
    }

    @Override
    public void enterAmpvar(HbsParser.AmpvarContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterTvar(HbsParser.TvarContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterVar(HbsParser.VarContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    private void trim(Token startToken, Token endToken) {
        int i;
        CommonToken rightToken;
        String end;
        CommonToken leftToken;
        int i2;
        String start = this.text(startToken);
        if (start.indexOf("~") > 0 && (i2 = startToken.getTokenIndex()) > 0 && (leftToken = (CommonToken)this.tokens.get(i2 - 1)) != null && leftToken.getType() == 2) {
            String trimmed = StringUtils.stripEnd(leftToken.getText(), null);
            leftToken.setText(trimmed);
        }
        if ((end = this.text(endToken)).indexOf("~") >= 0 && (rightToken = (CommonToken)this.tokens.get((i = endToken.getTokenIndex()) + 1)) != null && rightToken.getType() == 2) {
            String trimmed = StringUtils.stripStart(rightToken.getText(), null);
            rightToken.setText(trimmed);
        }
    }

    private String text(Token token) {
        return token.getText();
    }
}

