/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http2.impl.nio;

import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.Internal;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.URIScheme;
import wiremock.org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import wiremock.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import wiremock.org.apache.hc.core5.http2.HttpVersionPolicy;
import wiremock.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import wiremock.org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import wiremock.org.apache.hc.core5.reactor.EndpointParameters;
import wiremock.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import wiremock.org.apache.hc.core5.reactor.ProtocolIOSession;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.apache.hc.core5.util.Asserts;
import wiremock.org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientHttpProtocolNegotiatorFactory
implements IOEventHandlerFactory {
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ClientHttpProtocolNegotiatorFactory(ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public ClientHttpProtocolNegotiator createHandler(ProtocolIOSession ioSession, Object attachment) {
        HttpVersionPolicy endpointPolicy = this.versionPolicy;
        if (attachment instanceof EndpointParameters) {
            EndpointParameters params = (EndpointParameters)attachment;
            if (URIScheme.HTTPS.same(params.getScheme())) {
                Asserts.notNull(this.tlsStrategy, "TLS strategy");
                HttpHost host = new HttpHost(params.getScheme(), params.getHostName(), params.getPort());
                this.tlsStrategy.upgrade(ioSession, host, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), params.getAttachment(), this.handshakeTimeout);
            }
            if (params.getAttachment() instanceof HttpVersionPolicy) {
                endpointPolicy = (HttpVersionPolicy)((Object)params.getAttachment());
            }
        }
        return new ClientHttpProtocolNegotiator(ioSession, this.http1StreamHandlerFactory, this.http2StreamHandlerFactory, endpointPolicy);
    }
}

