/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePatternJsonDeserializer;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Constructor;

@JsonDeserialize(using=StringValuePatternJsonDeserializer.class)
public abstract class StringValuePattern
extends ContentPattern<String> {
    public static final AbsentPattern ABSENT = new AbsentPattern(null);

    public StringValuePattern(String expectedValue) {
        super(expectedValue);
    }

    @JsonIgnore
    public boolean isPresent() {
        return this != ABSENT;
    }

    public Boolean isAbsent() {
        return this != ABSENT ? null : Boolean.valueOf(true);
    }

    @JsonIgnore
    public Boolean nullSafeIsAbsent() {
        return this == ABSENT;
    }

    public String toString() {
        return this.getName() + " " + (String)this.getValue();
    }

    @Override
    public final String getName() {
        Constructor constructor = (Constructor)FluentIterable.from((Object[])this.getClass().getDeclaredConstructors()).firstMatch(new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> input) {
                return input.getParameterAnnotations().length > 0 && input.getParameterAnnotations()[0].length > 0 && input.getParameterAnnotations()[0][0] instanceof JsonProperty;
            }
        }).orNull();
        if (constructor == null) {
            throw new IllegalStateException("Constructor must have a first parameter annotatated with JsonProperty(\"<operator name>\")");
        }
        JsonProperty jsonPropertyAnnotation = (JsonProperty)constructor.getParameterAnnotations()[0][0];
        return jsonPropertyAnnotation.value();
    }

    @Override
    public String getExpected() {
        return (String)this.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValuePattern that = (StringValuePattern)o;
        return Objects.equal((Object)this.expectedValue, (Object)that.expectedValue);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expectedValue});
    }
}

