/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RenderableDate;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateTimeParser {
    private static final DateTimeFormatter RFC_1036_DATE_TIME = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss zzz").withLocale(Locale.US);
    private static final DateTimeFormatter ASCTIME1 = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy").withZone(ZoneId.of("GMT"));
    private static final DateTimeFormatter ASCTIME2 = DateTimeFormatter.ofPattern("EEE MMM  d HH:mm:ss yyyy").withZone(ZoneId.of("GMT"));
    public static final List<DateTimeParser> ZONED_PARSERS = Arrays.asList(DateTimeParser.forFormatter(DateTimeFormatter.ISO_ZONED_DATE_TIME), DateTimeParser.forFormatter(DateTimeFormatter.RFC_1123_DATE_TIME), DateTimeParser.forFormatter(RFC_1036_DATE_TIME), DateTimeParser.forFormatter(ASCTIME1), DateTimeParser.forFormatter(ASCTIME2));
    private final DateTimeFormatter dateTimeFormatter;
    private final boolean isUnix;
    private final boolean isEpoch;

    private DateTimeParser(DateTimeFormatter dateTimeFormatter, boolean isUnix, boolean isEpoch) {
        this.dateTimeFormatter = dateTimeFormatter;
        this.isUnix = isUnix;
        this.isEpoch = isEpoch;
    }

    public static DateTimeParser forFormat(String format) {
        if (format.equalsIgnoreCase("unix")) {
            return new DateTimeParser(null, true, false);
        }
        if (format.equalsIgnoreCase("epoch")) {
            return new DateTimeParser(null, false, true);
        }
        return DateTimeParser.forFormatter(DateTimeFormatter.ofPattern(format));
    }

    public static DateTimeParser forFormatter(DateTimeFormatter dateTimeFormatter) {
        return new DateTimeParser(dateTimeFormatter, false, false);
    }

    public ZonedDateTime parseZonedDateTime(String dateTimeString) {
        if (this.dateTimeFormatter != null) {
            return ZonedDateTime.parse(dateTimeString, this.dateTimeFormatter);
        }
        if (this.isUnix) {
            long epochMillis = Long.parseLong(dateTimeString) * 1000L;
            return Instant.ofEpochMilli(epochMillis).atZone(ZoneOffset.UTC);
        }
        if (this.isEpoch) {
            long epochMillis = Long.parseLong(dateTimeString);
            return Instant.ofEpochMilli(epochMillis).atZone(ZoneOffset.UTC);
        }
        return null;
    }

    public LocalDateTime parseLocalDateTime(String dateTimeString) {
        if (this.dateTimeFormatter != null) {
            return LocalDateTime.parse(dateTimeString, this.dateTimeFormatter);
        }
        if (this.isUnix) {
            long epochMillis = Long.parseLong(dateTimeString) * 1000L;
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC);
        }
        if (this.isEpoch) {
            long epochMillis = Long.parseLong(dateTimeString);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC);
        }
        return null;
    }

    public LocalDate parseLocalDate(String dateTimeString) {
        if (this.dateTimeFormatter != null) {
            return LocalDate.parse(dateTimeString, this.dateTimeFormatter);
        }
        return null;
    }

    public RenderableDate parseDate(String dateTimeString) {
        if (this.isUnix || this.isEpoch) {
            return new RenderableDate(Date.from(this.parseZonedDateTime(dateTimeString).toInstant()), null, null);
        }
        if (this.dateTimeFormatter == null) {
            return null;
        }
        TemporalAccessor parseResult = this.dateTimeFormatter.parse(dateTimeString);
        ZoneId timezoneId = parseResult.query(TemporalQueries.zone());
        Date date = timezoneId != null ? Date.from(Instant.from(parseResult)) : (parseResult.query(TemporalQueries.localTime()) != null ? Date.from(LocalDateTime.from(parseResult).toInstant(ZoneOffset.UTC)) : (parseResult.query(TemporalQueries.localDate()) != null ? Date.from(LocalDate.from(parseResult).atStartOfDay(ZoneOffset.UTC).toInstant()) : (parseResult.isSupported(ChronoField.MONTH_OF_YEAR) ? Date.from(YearMonth.from(parseResult).atDay(1).atStartOfDay(ZoneOffset.UTC).toInstant()) : Date.from(Year.from(parseResult).atMonth(1).atDay(1).atStartOfDay(ZoneOffset.UTC).toInstant()))));
        return new RenderableDate(date, null, timezoneId);
    }
}

