/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HandlebarsXPathHelper
extends HandlebarsHelper<String> {
    public Object apply(String inputXml, Options options) throws IOException {
        Document doc;
        if (inputXml == null) {
            return "";
        }
        if (options.param(0, null) == null) {
            return this.handleError("The XPath expression cannot be empty");
        }
        String xPathInput = (String)options.param(0);
        try (StringReader reader = new StringReader(inputXml);){
            InputSource source = new InputSource(reader);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(source);
        }
        catch (SAXException se) {
            return this.handleError(inputXml + " is not valid XML");
        }
        catch (ParserConfigurationException e) {
            return Exceptions.throwUnchecked(e, Object.class);
        }
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            Node node = (Node)xpath.evaluate(this.getXPathPrefix() + xPathInput, doc, XPathConstants.NODE);
            if (node == null) {
                return "";
            }
            return Xml.toStringValue(node);
        }
        catch (XPathExpressionException e) {
            return this.handleError(xPathInput + " is not a valid XPath expression", e);
        }
    }

    protected String getXPathPrefix() {
        return "";
    }
}

