/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Json;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class Scenario {
    public static final String STARTED = "Started";
    private final UUID id;
    private final String name;
    private final String state;
    private final Set<String> possibleStates;

    @JsonCreator
    public Scenario(@JsonProperty(value="id") UUID id, @JsonProperty(value="name") String name, @JsonProperty(value="state") String currentState, @JsonProperty(value="possibleStates") Set<String> possibleStates) {
        this.id = id;
        this.name = name;
        this.state = currentState;
        this.possibleStates = possibleStates;
    }

    public static Scenario inStartedState(String name) {
        return new Scenario(UUID.randomUUID(), name, STARTED, (Set<String>)ImmutableSet.of((Object)STARTED));
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public Set<String> getPossibleStates() {
        return this.possibleStates;
    }

    Scenario setState(String newState) {
        return new Scenario(this.id, this.name, newState, this.possibleStates);
    }

    Scenario reset() {
        return new Scenario(this.id, this.name, STARTED, this.possibleStates);
    }

    Scenario withPossibleState(String newScenarioState) {
        if (newScenarioState == null) {
            return this;
        }
        ImmutableSet newStates = ImmutableSet.builder().addAll(this.possibleStates).add((Object)newScenarioState).build();
        return new Scenario(this.id, this.name, this.state, (Set<String>)newStates);
    }

    public Scenario withoutPossibleState(String scenarioState) {
        return new Scenario(this.id, this.name, this.state, (Set<String>)FluentIterable.from(this.possibleStates).filter(Predicates.not((Predicate)Predicates.equalTo((Object)scenarioState))).toSet());
    }

    public String toString() {
        return Json.write(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario scenario = (Scenario)o;
        return Objects.equals(this.name, scenario.name) && Objects.equals(this.state, scenario.state) && Objects.equals(this.possibleStates, scenario.possibleStates);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.state, this.possibleStates);
    }

    public static final Predicate<Scenario> withName(final String name) {
        return new Predicate<Scenario>(){

            public boolean apply(Scenario input) {
                return input.getName().equals(name);
            }
        };
    }
}

